/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.xmlsoap.schemas.wsdl.TPort;

import com.ebmwebsourcing.commons.wsdl.api.Binding;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractEndpointImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractServiceImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class EndpointImpl extends AbstractEndpointImpl<TPort> implements
        com.ebmwebsourcing.commons.wsdl.api.Endpoint {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the parent serviceImpl
     */
    private ServiceImpl serviceImpl;

    public EndpointImpl() {

    }

    public EndpointImpl(final TPort endpoint, final ServiceImpl serviceImpl) {
        this.model = endpoint;
        this.serviceImpl = serviceImpl;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl(
                this.model.getDocumentation());

    }

    @SuppressWarnings("unchecked")
    public Binding getBinding() {
        final QName bindingName = this.model.getBinding();
        return ((AbstractServiceImpl) this.serviceImpl).getDescription().getBinding(bindingName);
    }

    public String getName() {
        return this.model.getName();
    }

    @SuppressWarnings("unchecked")
    public String getAddress() {
        String location = null;
        for (final Object element : this.model.getAny()) {
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap.TAddress) {
                location = ((org.xmlsoap.schemas.wsdl.soap.TAddress) ((JAXBElement) element)
                        .getValue()).getLocation();
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap12.TAddress) {
                location = ((org.xmlsoap.schemas.wsdl.soap12.TAddress) ((JAXBElement) element)
                        .getValue()).getLocation();
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.http.AddressType) {
                location = ((org.xmlsoap.schemas.wsdl.http.AddressType) ((JAXBElement) element)
                        .getValue()).getLocation();
                break;
            }
        }
        return location;
    }

    public void setBinding(final Binding binding) {
        throw new NotImplementedException();
    }

    public void setName(final String name) {
        this.model.setName(name);
    }

    @SuppressWarnings("unchecked")
    public void setAddress(final String address) {
        for (final Object element : this.model.getAny()) {
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap.TAddress) {
                ((org.xmlsoap.schemas.wsdl.soap.TAddress) ((JAXBElement) element).getValue())
                        .setLocation(address);
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.soap12.TAddress) {
                ((org.xmlsoap.schemas.wsdl.soap12.TAddress) ((JAXBElement) element).getValue())
                        .setLocation(address);
                break;
            }
            if (((JAXBElement) element).getValue() instanceof org.xmlsoap.schemas.wsdl.http.AddressType) {
                ((org.xmlsoap.schemas.wsdl.http.AddressType) ((JAXBElement) element).getValue())
                        .setLocation(address);
                break;
            }
        }
    }

    public String getHttpAuthenticationRealm() {
        return null;
    }

    public String getHttpAuthenticationScheme() {
        return null;
    }

}
