/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.xmlsoap.schemas.wsdl.TMessage;
import org.xmlsoap.schemas.wsdl.TParam;
import org.xmlsoap.schemas.wsdl.TPart;

import com.ebmwebsourcing.commons.schema.api.Element;
import com.ebmwebsourcing.commons.wsdl.api.Part;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractOperationImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractParamImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class InputImpl extends AbstractParamImpl<TParam> implements
        com.ebmwebsourcing.commons.wsdl.api.Input {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    private TMessage correspondingMessage = null;

    private final List<Part> parts = new ArrayList<Part>();

    @SuppressWarnings("unchecked")
    public InputImpl(final TParam param, final OperationImpl operationImpl) {
        this.model = param;
        this.operation = operationImpl;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl(
                this.model.getDocumentation());

        // get corresponding messages
        final DescriptionImpl desc = (com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DescriptionImpl) ((AbstractInterfaceTypeImpl) ((AbstractOperationImpl) this.operation)
                .getInterface()).getDescription();
        for (final TMessage msg : desc.getMessages()) {
            if (msg.getName().equals(this.getMessageName().getLocalPart())) {
                this.correspondingMessage = msg;
            }
        }

        // get parts
        for (final TPart part : this.correspondingMessage.getPart()) {
            this.parts.add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.PartImpl(part, this));
        }
    }

    public QName getMessageName() {
        return this.model.getMessage();
    }

    public void setMessageName(final QName name) {
        this.model.setMessage(name);
    }

    @Override
    public Element getElement() {
        Element res = null;
        if (this.parts.size() == 1) {
            res = this.parts.get(0).getElement();
        }
        return res;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public void setElement(final Element element) {
        throw new NotImplementedException();
    }

    public String getName() {
        return this.model.getName();
    }

    public void setName(final String name) {
        throw new NotImplementedException();
    }

    public Part getPart(final String name) {
        Part res = null;
        if (this.parts != null) {
            for (final Part p : this.parts) {
                if (p.getPartQName().getLocalPart().equals(name)) {
                    res = p;
                    break;
                }
            }
        }
        return res;
    }

}
