/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.xmlsoap.schemas.wsdl.TOperation;
import org.xmlsoap.schemas.wsdl.TOperation.RestItem;

import com.ebmwebsourcing.commons.wsdl.api.Fault;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractOperationImpl;
import com.ebmwebsourcing.commons.wsdl.impl.wsdl20.Constants;
import com.ebmwebsourcing.commons.wsdl.util.Constants.MEPPatternConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class OperationImpl extends AbstractOperationImpl<TOperation> implements
        com.ebmwebsourcing.commons.wsdl.api.Operation {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public OperationImpl(final TOperation op, final InterfaceTypeImpl itf) {
        this.model = op;
        this.itf = itf;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl(
                this.model.getDocumentation());

        for (final RestItem item : this.model.getRestItems()) {

            // get input
            if (item.getItemInput() != null) {
                this.input = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.InputImpl(item
                        .getItemInput(), this);
            }

            // get output
            if (item.getItemOutput() != null) {
                this.output = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.OutputImpl(item
                        .getItemOutput(), this);
            }

            // get fault
            if (item.getItemFault() != null) {
                this.faults.add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.FaultImpl(item
                        .getItemFault(), this));
            }
        }

    }

    public void addFault(final Fault fault) {
        throw new NotImplementedException();
    }

    @SuppressWarnings("unchecked")
    public QName getQName() {
        return new QName(((AbstractInterfaceTypeImpl) this.getInterface()).getDescription()
                .getTargetNamespace(), this.model.getName());
    }

    public List<String> getParameterOrdering() {
        List<String> res = this.model.getParameterOrder();
        if ((res != null) && (res.size() == 0)) {
            res = null;
        }
        return res;
    }

    public Fault removeFault(final String name) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) {
        this.model.setName(name.getLocalPart());
    }

    public void setParameterOrdering(final List<String> parameterOrder) {
        throw new NotImplementedException();
    }

    public MEPPatternConstants getPattern() {
        MEPPatternConstants pattern = null;
        for (final RestItem item : this.model.getRestItems()) {
            if (item.getItemOutput() != null) {
                pattern = MEPPatternConstants.IN_OUT;
            } else if ((item.getItemInput() != null) && (pattern == null)) {
                pattern = MEPPatternConstants.IN_ONLY;
            }
        }
        return pattern;
    }

    public void setPattern(final MEPPatternConstants pattern) throws WSDLException {
        if ((pattern.equals(MEPPatternConstants.IN_ONLY))
                || (pattern.equals(MEPPatternConstants.ROBUST_IN_ONLY))) {
            this.setOutput(null);
        } else {
            throw new WSDLException(Constants.NOT_SUPPORTED);
        }
    }

    public Fault getFaultByElementName(final QName name) {
        Fault res = null;
        for (final Fault f : this.faults) {
            if ((f.getElement() != null) && (f.getElement().getQName().equals(name))) {
                res = f;
                break;
            }
        }
        return res;
    }

    public Fault removeFaultByElementName(final QName name) {
        throw new NotImplementedException();
    }

}
