/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.xmlsoap.schemas.wsdl.TPort;
import org.xmlsoap.schemas.wsdl.TService;

import com.ebmwebsourcing.commons.wsdl.api.Endpoint;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractServiceImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ServiceImpl extends AbstractServiceImpl<TService> implements
        com.ebmwebsourcing.commons.wsdl.api.Service {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public ServiceImpl() {
        this.model = new TService();
    }

    public ServiceImpl(final TService service, final DescriptionImpl desc) {
        this.model = service;
        this.desc = desc;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DocumentationImpl(
                this.model.getDocumentation());

        // get the endpoint
        for (final TPort port : this.model.getPort()) {
            final Endpoint e = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.EndpointImpl(port,
                    this);
            this.endpoints.add(e);
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addEndpoint(final Endpoint endpoint) {
        super.addEndpoint(endpoint);
        this.model.getPort().add((TPort) ((AbstractWSDLElementImpl) endpoint).getModel());
    }

    public QName getQName() {
        QName serviceName = null;
        serviceName = new QName(this.desc.getTargetNamespace(), this.model.getName());
        return serviceName;
    }

    public Endpoint removeEndpoint(final String name) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) {
        throw new NotImplementedException();
    }

    public InterfaceType getInterface() throws WSDLException {
        InterfaceType res = null;
        InterfaceType item = null;
        for (final Endpoint ep : this.getEndpoints()) {
            item = ep.getBinding().getInterface();
            if (item != null) {
                res = item;
            }
            if (item != res) {
                throw new WSDLException(
                        "The endpoints of this service do not implement the same interface");
            }
        }
        return res;
    }

}
