/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import java.io.IOException;
import java.net.URL;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;

import com.ebmwebsourcing.commons.wsdl.api.WSDLException;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class WSDLJAXBContext {

    /**
     * The JAXB context
     */
    private static JAXBContext jaxbContext;

    /**
     * Private object initializations
     */
    protected static void createContext() throws WSDLException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

        // The EndpointReference schema resource is in the Jar where the class
        // is
        // loaded
        final URL schemaUrl11 = WSDLJAXBContext.class.getResource("/" + Constants.XSD_WSDL_11);

        try {
            factory.newSchema(new StreamSource[] { new StreamSource(schemaUrl11.openStream()) });

            WSDLJAXBContext.jaxbContext = JAXBContext.newInstance(new Class[] {
                    org.xmlsoap.schemas.wsdl.ObjectFactory.class,
                    org.xmlsoap.schemas.wsdl.http.ObjectFactory.class,
                    org.xmlsoap.schemas.wsdl.mime.ObjectFactory.class,
                    org.xmlsoap.schemas.wsdl.soap.ObjectFactory.class,
                    org.xmlsoap.schemas.soap.encoding.ObjectFactory.class,
                    org.xmlsoap.schemas.soap.envelope.ObjectFactory.class,
                    org.xmlsoap.schemas.wsdl.soap12.ObjectFactory.class,
                    org.w3._2003._05.soap_encoding.ObjectFactory.class,
                    org.w3._2003._05.soap_envelope.ObjectFactory.class,
                    org.w3._2001.xmlschema.ObjectFactory.class });

        } catch (final SAXException e) {
            throw new WSDLException(e);
        } catch (final IOException e) {
            throw new WSDLException(e);
        } catch (final JAXBException e) {
            throw new WSDLException(e);
        }

    }

    /**
     * @return the jaxbContext
     */
    public static JAXBContext getJaxbContext() {
        return WSDLJAXBContext.jaxbContext;
    }
}
