/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xmlsoap.schemas.wsdl.TDefinitions;

import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import com.ebmwebsourcing.commons.wsdl.util.WSDLJDomAnalyzer;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDLReaderImpl extends AbstractWSDLReaderImpl implements
        com.ebmwebsourcing.commons.wsdl.api.WSDLReader {

    /**
     * The JAXB unique unmarshaller.
     */
    private static Unmarshaller unmarshaller = null;

    /**
     * The exception raised during JAXB unique unmarshaller creation.
     */
    private static WSDLException unmarshallerCreationEx = null;

    /*
     * Private object initializations
     */
    static {
        try {

            WSDLJAXBContext.createContext();

            WSDLReaderImpl.unmarshaller = WSDLJAXBContext.getJaxbContext().createUnmarshaller();
            // unmarshaller.setSchema(schema);
        } catch (final JAXBException e) {
            final WSDLException jaxbContextCreationEx = new WSDLException(
                    "Failed to create jaxb context", e);
            WSDLReaderImpl.unmarshallerCreationEx = new WSDLException("Failed to create the JAXB unmarshaller",
                    jaxbContextCreationEx);

        } catch (final WSDLException e) {
            final WSDLException jaxbContextCreationEx = new WSDLException(
                    "Failed to create jaxb context", e);
            WSDLReaderImpl.unmarshallerCreationEx = new WSDLException("Failed to create the JAXB unmarshaller",
                    jaxbContextCreationEx);

        }
    }

    private static TDefinitions convertStream2WSDL11Definition(final Source wsdlDescriptorStream)
            throws WSDLException {

        try {
            // TODO : Check if it is a Thread safe method
            final JAXBElement<TDefinitions> wsdlBinding = WSDLReaderImpl.getUnMarshaller().unmarshal(
                    wsdlDescriptorStream, TDefinitions.class);

            return wsdlBinding.getValue();

        } catch (final JAXBException e) {
            throw new WSDLException(
                    "Failed to build Java bindings from WSDL descriptor XML document", e);
        }
    }

    /**
     * Get the unmarshaller instance.
     * 
     * @return the unmarshaller instance
     * @throws WSDLException
     *             The exception raised during the unmarshaller creation.
     */
    public static Unmarshaller getUnMarshaller() throws WSDLException {

        if (WSDLReaderImpl.unmarshallerCreationEx != null) {
            throw WSDLReaderImpl.unmarshallerCreationEx;
        }

        return WSDLReaderImpl.unmarshaller;
    }

    /**
     * @return the jaxbContext
     */
    public static JAXBContext getJaxbContext() {
        return WSDLJAXBContext.getJaxbContext();
    }

    public Description readWSDL(final URI wsdlURI) throws WSDLException {
        Description desc = null;
        try {
            InputStream input = null;
            final File f = new File(wsdlURI);
            if (f.exists()) {
                input = new FileInputStream(f);
            } else {
                input = wsdlURI.toURL().openStream();
            }
            desc = this.readWSDL(wsdlURI, SourceHelper.convertInputSource2DOMSource(new InputSource(
                    input)));
        } catch (final MalformedURLException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        } catch (final IOException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        } catch (final WSDLException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        } catch (final XmlException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        return desc;
    }

    public Description readWSDL(final Document wsdlDocument) throws WSDLException {
        Description desc = null;
        try {
            desc = this.readWSDL(new URI(wsdlDocument.getDocumentURI()), new DOMSource(wsdlDocument));
        } catch (final URISyntaxException e) {
            throw new WSDLException(e);
        }
        return desc;
    }

    public Description readWSDL(final URI baseURI, final DOMSource inputSource) throws WSDLException {
        Description desc = null;
        try {

            if (this.analyzer == null) {
                final DOMSource sourcebis = SourceHelper.cloneSource(inputSource);
                this.analyzer = new WSDLJDomAnalyzer(SourceHelper
                        .convertDOMSource2InputSource(sourcebis));
            }
            final DOMSource source = SourceHelper.cloneSource(inputSource);
            final TDefinitions def = WSDLReaderImpl.convertStream2WSDL11Definition(source);
            desc = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DescriptionImpl(baseURI, def,
                    this.analyzer.getDocument(), this.getFeatures());
        } catch (final JDOMException e) {
            throw new WSDLException(e);
        } catch (final XmlException e) {
            throw new WSDLException(e);
        }
        return desc;
    }

}
