/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.mime;

import java.util.ArrayList;
import java.util.List;

import org.xmlsoap.schemas.wsdl.mime.ContentType;
import org.xmlsoap.schemas.wsdl.mime.MultipartRelatedType;
import org.xmlsoap.schemas.wsdl.mime.TMimeXml;

import com.ebmwebsourcing.commons.wsdl.api.BindingParam;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class MIMEBindingImpl implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEBinding4Wsdl11 {

    private final List<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEContent> contents = new ArrayList<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEContent>();

    private final List<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEMultipartRelated> multiparts = new ArrayList<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEMultipartRelated>();

    private final List<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEXml> mimeXmls = new ArrayList<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEXml>();

    private BindingParam param = null;

    public MIMEBindingImpl(final List<ContentType> contents, final List<TMimeXml> mimeXmls,
            final List<MultipartRelatedType> multiparts, final BindingParam param) {
        this.param = param;
        if (contents != null) {
            for (final ContentType content : contents) {
                this.contents.add(new MIMEContentImpl(content));
            }
        }
        if (mimeXmls != null) {
            for (final TMimeXml content : mimeXmls) {
                this.mimeXmls.add(new MIMEXmlImpl(content));
            }
        }
        if (multiparts != null) {
            for (final MultipartRelatedType mpart : multiparts) {
                this.multiparts.add(new MIMEMultipartRelatedImpl(mpart, this.param));
            }
        }
    }

    public List<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEContent> getContents() {
        return this.contents;
    }

    public List<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEMultipartRelated> getMultipartRelateds() {
        return this.multiparts;
    }

    public List<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEXml> getMimeXml() {
        return this.mimeXmls;
    }

}
