/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.mime;

import java.util.ArrayList;
import java.util.List;

import org.xmlsoap.schemas.wsdl.mime.MultipartRelatedType;
import org.xmlsoap.schemas.wsdl.mime.TPart;

import com.ebmwebsourcing.commons.wsdl.api.BindingParam;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class MIMEMultipartRelatedImpl implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEMultipartRelated {

    private final MultipartRelatedType multipart;

    private BindingParam param = null;

    private final List<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEPart> parts = new ArrayList<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEPart>();

    public MIMEMultipartRelatedImpl(final MultipartRelatedType multipart, final BindingParam param) {
        this.param = param;
        this.multipart = multipart;

        for (final TPart part : this.multipart.getPart()) {
            this.parts
                    .add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.mime.MIMEPartImpl(
                            part, param));
        }
    }

    public List<com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEPart> getParts() {
        return this.parts;
    }

    /**
     * @return the param
     */
    public BindingParam getParam() {
        return this.param;
    }

}
