/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.mime;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.xmlsoap.schemas.wsdl.mime.TPart;

import com.ebmwebsourcing.commons.wsdl.api.BindingParam;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractBindingOperationImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractBindingParamImpl;
import com.ebmwebsourcing.commons.wsdl.api.binding.BindingProtocol;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class MIMEPartImpl implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.mime.MIMEPart {

    private final TPart part;

    private final BindingParam param;

    private final BindingProtocol bindingProtocol;

    /**
     * 
     * @param part
     * @param elmt
     * @param param
     */
    @SuppressWarnings("unchecked")
    public MIMEPartImpl(final TPart part, final BindingParam param) {
        this.part = part;
        this.param = param;

        // get the binding protocol
        this.bindingProtocol = AbstractBindingParamImpl.extractBindingProtocol((List) this.part
                .getAnyItems(), (AbstractBindingParamImpl) this.param);
    }

    @SuppressWarnings("unchecked")
    public QName getPartQName() {
        QName res = null;
        if (this.part.getName() != null) {
            res = new QName(((AbstractBindingOperationImpl) ((AbstractBindingParamImpl) this.param)
                    .getBindingOperation()).getQName().getNamespaceURI(), this.part.getName());
        }
        return res;
    }

    public void setPartQName(final QName name) {
        throw new NotImplementedException();
    }

    public BindingProtocol getBindingProtocol() {
        return this.bindingProtocol;
    }

}
