/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap11;

import java.util.ArrayList;
import java.util.List;

import org.xmlsoap.schemas.wsdl.soap.TBody;
import org.xmlsoap.schemas.wsdl.soap.TFault;
import org.xmlsoap.schemas.wsdl.soap.THeader;

import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Body;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Fault;
import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Header;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SOAP11BindingImpl implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Binding4Wsdl11 {

    SOAP11Body soap11body = null;

    List<SOAP11Header> soap11headers = new ArrayList<SOAP11Header>();

    SOAP11Fault soap11fault = null;

    public SOAP11BindingImpl(final List<THeader> headers, final TBody body, final TFault fault) {
        if (headers != null) {
            for (final THeader h : headers) {
                this.soap11headers
                        .add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap11.SOAP11HeaderImpl(
                                h));
            }
        }
        if (body != null) {
            this.soap11body = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap11.SOAP11BodyImpl(
                    body);
        }
        if (fault != null) {
            this.soap11fault = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap11.SOAP11FaultImpl(
                    fault);
        }
    }

    public List<SOAP11Header> getHeaders() {
        return this.soap11headers;
    }

    public SOAP11Body getBody() {
        return this.soap11body;
    }

    public SOAP11Fault getFault() {
        return this.soap11fault;
    }
}
