/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap12;

import java.util.ArrayList;
import java.util.List;

import org.xmlsoap.schemas.wsdl.soap12.TBody;
import org.xmlsoap.schemas.wsdl.soap12.TBody.PartsItem;

import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.SOAPBinding4Wsdl11.UseConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SOAP12BodyImpl implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap12.SOAP12Body {

    private final TBody body;

    public SOAP12BodyImpl(final TBody body) {
        this.body = body;
    }

    public String getEncodingStyle() {
        return this.body.getEncodingStyle();
    }

    public String getNamespace() {
        return this.body.getNamespace();
    }

    public UseConstants getUse() {
        UseConstants res = null;
        if (this.body.getUse() != null) {
            if (this.body.getUse().value().equals(UseConstants.ENCODED.value())) {
                res = UseConstants.ENCODED;
            } else if (this.body.getUse().value().equals(UseConstants.LITERAL.value())) {
                res = UseConstants.LITERAL;
            }
        }
        return res;
    }

    public List<String> getParts() {
        List<String> res = null;
        if ((this.body.getPartsItems() != null) && (this.body.getPartsItems().size() > 0)) {
            res = new ArrayList<String>();
            for (final PartsItem item : this.body.getPartsItems()) {
                res.add(item.getItem());
            }
        }
        return res;
    }

    public Boolean getRequired() {
        return this.body.isRequired();
    }
}
