/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl11.binding.soap.soap12;

import javax.xml.namespace.QName;

import org.xmlsoap.schemas.wsdl.soap12.THeaderFault;

import com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.SOAPBinding4Wsdl11.UseConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SOAP12HeaderFaultImpl implements
        com.ebmwebsourcing.commons.wsdl.api.binding.wsdl11.soap.soap12.SOAP12HeaderFault {

    private final THeaderFault headerFault;

    public SOAP12HeaderFaultImpl(final THeaderFault headerFault) {
        this.headerFault = headerFault;
    }

    public String getEncodingStyle() {
        return this.headerFault.getEncodingStyle();
    }

    public String getNamespace() {
        return this.headerFault.getNamespace();
    }

    public UseConstants getUse() {
        UseConstants res = null;
        if (this.headerFault.getUse() != null) {
            res = UseConstants.valueOf(this.headerFault.getUse().value());
        }
        return res;
    }

    public QName getMessage() {
        return this.headerFault.getMessage();
    }

    public String getPart() {
        return this.headerFault.getPart();
    }
}
