/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.w3.ns.wsdl.BindingOperationType;
import org.w3.ns.wsdl.BindingOperationType.InputOrOutputOrInfaultItem;
import org.w3c.dom.Element;

import com.ebmwebsourcing.commons.wsdl.api.BindingFault;
import com.ebmwebsourcing.commons.wsdl.api.Operation;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.Binding.StyleConstant;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractBindingOperationImpl;
import com.ebmwebsourcing.commons.wsdl.util.Constants.SOAPMEPConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BindingOperationImpl extends AbstractBindingOperationImpl<BindingOperationType>
        implements com.ebmwebsourcing.commons.wsdl.api.BindingOperation {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public BindingOperationImpl(final BindingOperationType bindingOperation, final BindingImpl bindingImpl) {
        this.model = bindingOperation;
        this.binding = bindingImpl;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl(
                this.model.getDocumentation());

        // get the input binding
        for (final InputOrOutputOrInfaultItem item : this.model.getInputOrOutputOrInfaultItems()) {
            // get input
            if (item.getItemInput() != null) {
                this.input = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.BindingInputImpl(item
                        .getItemInput(), this);
            }

            // get output
            if (item.getItemOutput() != null) {
                this.output = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.BindingOutputImpl(
                        item.getItemOutput(), this);
            }

            // get fault
            if (item.getItemInfault() != null) {
                this.faults.add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.BindingFaultImpl(
                        item.getItemInfault(), this));
            }

            // get fault
            if (item.getItemOutfault() != null) {
                this.faults.add(new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.BindingFaultImpl(
                        item.getItemOutfault(), this));
            }
        }
    }

    public void addFault(final BindingFault bindingFault) {
        throw new NotImplementedException();
    }

    public BindingFault removeFault(final String name) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) {
        throw new NotImplementedException();
    }

    public void setOperation(final Operation operation) {
        throw new NotImplementedException();
    }

    public QName getQName() {
        return this.model.getRef();
    }

    public SOAPMEPConstants getMEP() {
        SOAPMEPConstants mep = null;
        for (final Entry<QName, String> attribute : this.model.getOtherAttributes().entrySet()) {
            if ((attribute.getKey().getLocalPart().equals(Constants.MEP_ATTRIBUTE))
                    && (attribute.getKey().getNamespaceURI()
                            .equals(com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.SOAP_BINDING4WSDL20
                                    .value().toString()))) {
                try {
                    mep = SOAPMEPConstants.valueOf(new URI(attribute.getValue()));
                } catch (final URISyntaxException e) {
                    mep = null;
                }
                break;
            }
        }
        return mep;
    }

    public void setMEP(final SOAPMEPConstants mep) {
        throw new NotImplementedException();
    }

    public StyleConstant getStyle() {
        return StyleConstant.DOCUMENT;
    }

    public String getHttpLocation() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "location"));
    }

    public String getSoapAction() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.SOAP_BINDING4WSDL20
                                        .value().toString(), "action"));
    }

    public String getHttpContentEncodingDefault() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "contentEncodingDefault"));
    }

    public String getHttpFaultSerialization() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "faultSerialization"));
    }

    public String getHttpInputSerialization() {
        String res = null;
        res = this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "inputSerialization"));
        if (res == null) {
            if (("GET".equals(this.getHttpMethod())) || ("DELETE".equals(this.getHttpMethod()))) {
                res = "application/x-www-form-urlencoded";
            } else if (("POST".equals(this.getHttpMethod()))
                    || ("PUT".equals(this.getHttpMethod()))) {
                res = "	application/xml";
            }
        }
        return res;
    }

    public String getHttpMethod() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "method"));
    }

    public String getHttpOutputSerialization() {
        String res = null;
        res = this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "outputSerialization"));
        if (res == null) {
            res = "	application/xml";
        }
        return res;
    }

    public String getHttpQueryParameterSeparator() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "queryParameterSeparator"));
    }

    public boolean isHttpIgnoreUncited() {
        return Boolean
                .valueOf(this.model
                        .getOtherAttributes()
                        .get(
                                new QName(
                                        com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                                .value().toString(), "ignoreUncited")));

    }

    public List<Element> getOtherElements() throws WSDLException {
        List<Element> res = super.getOtherElements();
    
        for(Object item: this.model.getInputOrOutputOrInfault()) {
        	if(item instanceof Element) {
        		res.add((Element) item);
        	}
        }
        
        return res;
    }
}
