/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.net.URI;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.jdom.Document;
import org.w3.ns.wsdl.BindingType;
import org.w3.ns.wsdl.DescriptionType;
import org.w3.ns.wsdl.ImportType;
import org.w3.ns.wsdl.IncludeType;
import org.w3.ns.wsdl.ServiceType;
import org.w3.ns.wsdl.DescriptionType.ImportOrIncludeOrTypesItem;
import org.w3c.dom.Element;

import com.ebmwebsourcing.commons.wsdl.api.Binding;
import com.ebmwebsourcing.commons.wsdl.api.BindingFault;
import com.ebmwebsourcing.commons.wsdl.api.BindingOperation;
import com.ebmwebsourcing.commons.wsdl.api.Endpoint;
import com.ebmwebsourcing.commons.wsdl.api.Fault;
import com.ebmwebsourcing.commons.wsdl.api.Import;
import com.ebmwebsourcing.commons.wsdl.api.Include;
import com.ebmwebsourcing.commons.wsdl.api.Input;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;
import com.ebmwebsourcing.commons.wsdl.api.Operation;
import com.ebmwebsourcing.commons.wsdl.api.Output;
import com.ebmwebsourcing.commons.wsdl.api.Part;
import com.ebmwebsourcing.commons.wsdl.api.Service;
import com.ebmwebsourcing.commons.wsdl.api.Types;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader.FeatureConstants;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractDescriptionImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import com.ebmwebsourcing.commons.wsdl.util.Constants.WSDLVersionConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DescriptionImpl extends AbstractDescriptionImpl<DescriptionType> implements
        com.ebmwebsourcing.commons.wsdl.api.Description {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    @SuppressWarnings("unchecked")
    public DescriptionImpl(final URI baseURI, final DescriptionType description, final Document document,
            final Map<FeatureConstants, Object> features) throws WSDLException {
        super(baseURI, description, document, features);

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl(
                this.model.getDocumentation());

        for (final Object element : this.model.getImportOrIncludeOrTypes()) {

            if (element instanceof JAXBElement) {
                final Object part = ((JAXBElement) element).getValue();

                // get imports
                if (part instanceof ImportType) {
                    final Import impt = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.ImportImpl(
                            (ImportType) part, this);
                    this.imports.add(impt);
                }

                // get includes
                if (part instanceof IncludeType) {
                    final Include incl = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.IncludeImpl(
                            (IncludeType) part, this);
                    this.includes.add(incl);
                }

                // get services
                if (part instanceof ServiceType) {
                    final Service s = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.ServiceImpl(
                            (ServiceType) part, this);
                    this.services.add(s);
                }

                // get bindings
                if (part instanceof BindingType) {
                    final Binding b = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.BindingImpl(
                            (BindingType) part, this);
                    this.bindings.add(b);
                }

                // get interfaces
                if (part instanceof org.w3.ns.wsdl.InterfaceType) {
                    final InterfaceType itf = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.InterfaceTypeImpl(
                            (org.w3.ns.wsdl.InterfaceType) part, this);
                    this.interfaces.add(itf);
                }

                // get types
                if (part instanceof org.w3.ns.wsdl.TypesType) {
                    this.types = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.TypesImpl(
                            (org.w3.ns.wsdl.TypesType) part, this);
                }
            }
        }

        this.addImportElementsInAllList();
        this.addIncludeElementsInAllList();
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addBinding(final Binding binding) {
        super.addBinding(binding);
        this.model.getImportOrIncludeOrTypes().add(((AbstractWSDLElementImpl) binding).getModel());
    }

    @Override
    public void addImport(final Import importDef) {
        throw new NotImplementedException();
    }

    public void addNamespace(final String prefix, final String namespaceURI) {
        throw new NotImplementedException();
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addInterface(final InterfaceType interfaceType) {
        super.addInterface(interfaceType);
        this.model.getImportOrIncludeOrTypes().add(
                ((AbstractWSDLElementImpl) interfaceType).getModel());
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addService(final Service service) {
        super.addService(service);
        this.model.getImportOrIncludeOrTypes().add(((AbstractWSDLElementImpl) service).getModel());
    }

    public Binding createBinding() {
        throw new NotImplementedException();
    }

    public BindingFault createBindingFault() {
        throw new NotImplementedException();
    }

    public BindingOperation createBindingOperation() {
        throw new NotImplementedException();
    }

    public Fault createFault() {
        throw new NotImplementedException();
    }

    public Import createImport() {
        throw new NotImplementedException();
    }

    public Input createInput() {
        throw new NotImplementedException();
    }

    public Operation createOperation() {
        throw new NotImplementedException();
    }

    public Output createOutput() {
        throw new NotImplementedException();
    }

    public Part createPart() {
        throw new NotImplementedException();
    }

    public Endpoint createEndpoint() {
        throw new NotImplementedException();
    }

    public InterfaceType createInterface() {
        throw new NotImplementedException();
    }

    public Service createService() {
        throw new NotImplementedException();
    }

    public Types createTypes() {
        throw new NotImplementedException();
    }

    public QName getQName() throws WSDLException {
        return null;
    }

    public String getTargetNamespace() {
        return this.model.getTargetNamespace();
    }

    public Binding removeBinding(final QName name) {
        throw new NotImplementedException();
    }

    public Import removeImport(final Import importDef) {
        throw new NotImplementedException();
    }

    public String removeNamespace(final String prefix) {
        throw new NotImplementedException();
    }

    public InterfaceType removeInterface(final QName name) {
        throw new NotImplementedException();
    }

    public Service removeService(final QName name) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) throws WSDLException {
        throw new WSDLException(Constants.NOT_SUPPORTED);
    }

    public void setTargetNamespace(final String targetNamespace) {
        throw new NotImplementedException();
    }

    @Override
    public void setTypes(final Types types) {
        throw new NotImplementedException();
    }

    public Include removeInclude(final Include includeDef) {
        throw new NotImplementedException();
    }

    public WSDLVersionConstants getVersion() {
        return WSDLVersionConstants.WSDL20;
    }
    
    public List<Element> getOtherElements() throws WSDLException {
        List<Element> res = super.getOtherElements();
    
        for(Object item: this.model.getImportOrIncludeOrTypes()) {
        	if(item instanceof Element) {
        		res.add((Element) item);
        	}
        }
        
        return res;
    }
}
