/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.w3.ns.wsdl.DocumentationType;

import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DocumentationImpl extends AbstractWSDLElementImpl<List<DocumentationType>> implements
        com.ebmwebsourcing.commons.wsdl.api.Documentation {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public DocumentationImpl() {
        final DocumentationType doc = new DocumentationType();
        this.model = new ArrayList<DocumentationType>();
        this.model.add(doc);
    }

    public DocumentationImpl(final List<DocumentationType> docs) {
        this.model = docs;
    }

    public String getContent() {
        final StringBuffer res = new StringBuffer();
        for (final DocumentationType doc : this.model) {
            final Iterator<DocumentationType.ContentItem> it = doc.getContentItems().iterator();
            String text = null;
            while (it.hasNext()) {
                text = it.next().getText();
                res.append(text + "\n");
            }
        }
        return res.substring(0, res.lastIndexOf("\n"));
    }

    public void setContent(final String content) {
        this.model.clear();
        final DocumentationType doc = new DocumentationType();
        final DocumentationType.ContentItem contentItem = new DocumentationType.ContentItem();
        contentItem.setText(content);
        doc.getContentItems().add(contentItem);
        this.model.add(doc);
    }

}
