/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.w3.ns.wsdl.EndpointType;
import org.w3c.dom.Element;

import com.ebmwebsourcing.commons.wsdl.api.Binding;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractEndpointImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class EndpointImpl extends AbstractEndpointImpl<EndpointType> implements
        com.ebmwebsourcing.commons.wsdl.api.Endpoint {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * the parent serviceImpl
     */
    private ServiceImpl serviceImpl;

    public EndpointImpl() {

    }

    public EndpointImpl(final EndpointType endpoint, final ServiceImpl serviceImpl) {
        this.model = endpoint;
        this.serviceImpl = serviceImpl;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl(
                this.model.getDocumentation());
    }

    public Binding getBinding() {
        final QName bindingName = this.model.getBinding();
        return this.serviceImpl.getDescription().getBinding(bindingName);
    }

    public String getName() {
        return this.model.getName();
    }

    public String getAddress() {
        return this.model.getAddress();
    }

    public void setBinding(final Binding binding) {
        throw new NotImplementedException();
    }

    public void setName(final String name) {
        this.model.setName(name);
    }

    public void setAddress(final String address) {
        this.model.setAddress(address);
    }

    public String getHttpAuthenticationRealm() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "authenticationScheme"));
    }

    public String getHttpAuthenticationScheme() {
        return this.model
                .getOtherAttributes()
                .get(
                        new QName(
                                com.ebmwebsourcing.commons.wsdl.api.Binding.BindingConstants.HTTP_BINDING4WSDL20
                                        .value().toString(), "authenticationRealm"));
    }

    public List<Element> getOtherElements() throws WSDLException {
        List<Element> res = super.getOtherElements();
    
        for(Object item: this.model.getAny()) {
        	if(item instanceof Element) {
        		res.add((Element) item);
        	}
        }
        
        return res;
    }
}
