/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.w3.ns.wsdl.EndpointType;
import org.w3.ns.wsdl.ServiceType;
import org.w3c.dom.Element;

import com.ebmwebsourcing.commons.wsdl.api.Endpoint;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractServiceImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ServiceImpl extends AbstractServiceImpl<ServiceType> implements
        com.ebmwebsourcing.commons.wsdl.api.Service {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public ServiceImpl() {
        this.model = new ServiceType();
    }

    @SuppressWarnings("unchecked")
    public ServiceImpl(final ServiceType service, final DescriptionImpl desc) {
        this.model = service;
        this.desc = desc;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl(
                this.model.getDocumentation());

        for (final Object element : this.model.getEndpointOrAny()) {
            if (element instanceof JAXBElement) {
                final Object part = ((JAXBElement) element).getValue();

                // get the endpoint
                if (part instanceof EndpointType) {
                    final Endpoint e = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.EndpointImpl(
                            (EndpointType) part, this);
                    this.endpoints.add(e);
                }
            }
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void addEndpoint(final Endpoint endpoint) {
        super.addEndpoint(endpoint);
        this.model.getEndpointOrAny().add(((AbstractWSDLElementImpl) endpoint).getModel());
    }

    public QName getQName() {
        QName serviceName = null;
        serviceName = new QName(this.desc.getTargetNamespace(), this.model.getName());
        return serviceName;
    }

    public Endpoint removeEndpoint(final String name) {
        throw new NotImplementedException();
    }

    public void setQName(final QName name) {
        throw new NotImplementedException();
    }

    public InterfaceType getInterface() throws WSDLException {
        return this.desc.getInterface(this.model.getInterface());
    }
    
    public List<Element> getOtherElements() throws WSDLException {
        List<Element> res = super.getOtherElements();
    
        for(Object item: this.model.getEndpointOrAny()) {
        	if(item instanceof Element) {
        		res.add((Element) item);
        	}
        }
        
        return res;
    }

}
