/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.jdom.Document;
import org.w3.ns.wsdl.TypesType;
import org.w3.ns.wsdl.TypesType.AnyItem;
import org.w3c.dom.Element;

import com.ebmwebsourcing.commons.schema.api.SchemaException;
import com.ebmwebsourcing.commons.schema.api.SchemaReader.FeatureConstants;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractTypesImpl;
import com.ebmwebsourcing.commons.wsdl.util.Util;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class TypesImpl extends AbstractTypesImpl<TypesType> implements
        com.ebmwebsourcing.commons.wsdl.api.Types {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    public TypesImpl(final TypesType types, final DescriptionImpl desc) throws WSDLException {
        this.model = types;
        this.desc = desc;

        // get the documentation
        this.documentation = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DocumentationImpl(
                this.model.getDocumentation());

        final List<org.w3._2001.xmlschema.Schema> scs = new ArrayList<org.w3._2001.xmlschema.Schema>();
        for (final AnyItem item : this.model.getAnyItems()) {

            if (item.getItem() instanceof org.w3._2001.xmlschema.Schema) {
                scs.add((org.w3._2001.xmlschema.Schema) item.getItem());
            }

            if (item.getItem() instanceof org.w3._2001.xmlschema.Import) {
                final com.ebmwebsourcing.commons.schema.api.Import impt = new com.ebmwebsourcing.commons.schema.impl.Import(
                        this.desc.getDocumentBaseURI(), (org.w3._2001.xmlschema.Import) item
                                .getItem(), Util.convertWSDLFeatures2SchemaFeature(this.desc));
                this.importedSchemas.add(impt);
            }
        }

        this.addImportedSchemasInAllList();

        final List<Document> schemaDocuments = this.getSchemaDocuments();

        if (schemaDocuments.size() != (scs.size() + this.importedSchemas.size())) {
            throw new WSDLException("Error in validation of types");
        }

        final Map<FeatureConstants, Object> features = Util.convertWSDLFeatures2SchemaFeature(this.desc);

        try {
            int i = 0;
            for (final org.w3._2001.xmlschema.Schema schema : scs) {
                this.schemas.add(new com.ebmwebsourcing.commons.schema.impl.Schema(this.desc
                        .getDocumentBaseURI(), schema, schemaDocuments.get(i), features));
                i++;
            }
        } catch (final SchemaException e) {
            throw new WSDLException(e);
        }

        this.setAllNamespacesInAllSchemas();
    }

    public List<Element> getOtherElements() throws WSDLException {
        List<Element> res = super.getOtherElements();
    
        for(Object item: this.model.getAny()) {
        	if(item instanceof Element) {
        		res.add((Element) item);
        	}
        }
        
        return res;
    }
}
