/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import com.ebmwebsourcing.commons.schema.api.abstractElmt.AbstractSchema;
import com.ebmwebsourcing.commons.schema.api.extensions.NamespaceContext;
import com.ebmwebsourcing.commons.wsdl.api.Binding;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.Import;
import com.ebmwebsourcing.commons.wsdl.api.Include;
import com.ebmwebsourcing.commons.wsdl.api.InterfaceType;
import com.ebmwebsourcing.commons.wsdl.api.Service;
import com.ebmwebsourcing.commons.wsdl.api.Types;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDescriptionImpl<E>
extends AbstractWSDLElementImpl<E>
implements Description {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(AbstractSchema.class.getName());
    private Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    protected Map<WSDLReader.FeatureConstants, Object> features = new HashMap<WSDLReader.FeatureConstants, Object>();
    protected javax.xml.namespace.NamespaceContext namespaceContext;
    protected Document document;
    protected List<Import> imports = new ArrayList<Import>();
    protected List<Include> includes = new ArrayList<Include>();
    protected List<Service> services = new ArrayList<Service>();
    protected List<Binding> bindings = new ArrayList<Binding>();
    protected List<InterfaceType> interfaces = new ArrayList<InterfaceType>();
    protected Types types;
    protected URI baseURI;
    protected Map<String, String> schemaLocations = new HashMap<String, String>();

    public AbstractDescriptionImpl(URI baseURI, E model, Document doc, Map<WSDLReader.FeatureConstants, Object> features) throws WSDLException {
        this.model = model;
        this.features = features;
        this.document = doc;
        this.baseURI = baseURI;
        this.namespaceContext = new NamespaceContext();
        List namespaces = this.document.getRootElement().getAdditionalNamespaces();
        for (Namespace ns : namespaces) {
            if ((ns.getPrefix() == null || ns.getPrefix().equals("")) && this.document.getRootElement().getNamespace().getURI().equals(ns.getURI())) {
                ((NamespaceContext)this.namespaceContext).addNamespace(this.document.getRootElement().getNamespace().getPrefix(), this.document.getRootElement().getNamespace().getURI());
                continue;
            }
            ((NamespaceContext)this.namespaceContext).addNamespace(ns.getPrefix(), ns.getURI());
        }
        if (this.document.getRootElement().getAttributeValue("schemaLocation", this.xsi) != null) {
            String val = this.document.getRootElement().getAttributeValue("schemaLocation", this.xsi);
            StringTokenizer st = new StringTokenizer(val, " ");
            String location = null;
            String ns = null;
            while (st.hasMoreTokens()) {
                ns = st.nextToken();
                location = st.hasMoreTokens() ? st.nextToken() : null;
                if (ns != null) {
                    this.schemaLocations.put(ns, location);
                }
                ns = null;
            }
        }
    }

    protected void addImportElementsInAllList() {
        for (Import impt : this.imports) {
            if (impt.getDescription() == null) continue;
            this.services.addAll(impt.getDescription().getServices());
            this.bindings.addAll(impt.getDescription().getBindings());
            this.interfaces.addAll(impt.getDescription().getInterfaces());
            if (this.types != null) {
                this.types.getSchemas().addAll(impt.getDescription().getTypes().getSchemas());
                continue;
            }
            this.types = impt.getDescription().getTypes();
        }
    }

    protected void addIncludeElementsInAllList() {
        for (Include incl : this.includes) {
            if (incl.getDescription() == null) continue;
            this.services.addAll(incl.getDescription().getServices());
            this.bindings.addAll(incl.getDescription().getBindings());
            this.interfaces.addAll(incl.getDescription().getInterfaces());
            if (this.types != null) {
                this.types.getSchemas().addAll(incl.getDescription().getTypes().getSchemas());
                continue;
            }
            this.types = incl.getDescription().getTypes();
        }
    }

    @Override
    public void addImport(Import impt) {
        if (this.imports == null) {
            this.imports = new ArrayList<Import>();
        }
        this.imports.add(impt);
    }

    @Override
    public List<Import> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList<Import>();
        }
        return this.imports;
    }

    @Override
    public List<Import> getImports(String namespaceUri) {
        ArrayList<Import> res = new ArrayList<Import>();
        for (Import impt : this.imports) {
            if (!impt.getNamespaceURI().equals(namespaceUri)) continue;
            res.add(impt);
        }
        return res;
    }

    @Override
    public void addInclude(Include incl) throws WSDLException {
        if (this.includes == null) {
            this.includes = new ArrayList<Include>();
        }
        this.includes.add(incl);
    }

    @Override
    public List<Include> getIncludes() {
        if (this.includes == null) {
            this.includes = new ArrayList<Include>();
        }
        return this.includes;
    }

    @Override
    public List<Include> getIncludes(String locationUri) {
        ArrayList<Include> res = new ArrayList<Include>();
        for (Include incl : this.includes) {
            if (!incl.getLocationURI().equals(locationUri)) continue;
            res.add(incl);
        }
        return res;
    }

    @Override
    public void addService(Service service) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(service);
    }

    @Override
    public List<Service> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        return this.services;
    }

    @Override
    public Service getService(QName name) {
        Service res = null;
        for (Service s : this.services) {
            if (!s.getQName().equals(name)) continue;
            res = s;
            break;
        }
        return res;
    }

    @Override
    public void addBinding(Binding binding) {
        if (this.bindings == null) {
            this.bindings = new ArrayList<Binding>();
        }
        this.bindings.add(binding);
    }

    @Override
    public List<Binding> getBindings() {
        if (this.bindings == null) {
            this.bindings = new ArrayList<Binding>();
        }
        return this.bindings;
    }

    @Override
    public Binding getBinding(QName name) {
        Binding res = null;
        for (Binding b : this.bindings) {
            if (!b.getQName().equals(name)) continue;
            res = b;
            break;
        }
        return res;
    }

    @Override
    public void addInterface(InterfaceType itf) {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<InterfaceType>();
        }
        this.interfaces.add(itf);
    }

    @Override
    public List<InterfaceType> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<InterfaceType>();
        }
        return this.interfaces;
    }

    @Override
    public InterfaceType getInterface(QName name) {
        InterfaceType res = null;
        for (InterfaceType i : this.interfaces) {
            if (!i.getQName().equals(name)) continue;
            res = i;
            break;
        }
        return res;
    }

    public Map<WSDLReader.FeatureConstants, Object> getFeatures() {
        if (this.features == null) {
            this.features = new HashMap<WSDLReader.FeatureConstants, Object>();
        }
        return this.features;
    }

    public Object getFeatureValue(WSDLReader.FeatureConstants feature) {
        if (this.features == null) {
            this.features = new HashMap<WSDLReader.FeatureConstants, Object>();
        }
        return this.features.get((Object)feature);
    }

    public void setFeatures(Map<WSDLReader.FeatureConstants, Object> features) {
        this.features = features;
    }

    @Override
    public Types getTypes() {
        return this.types;
    }

    @Override
    public void setTypes(Types types) {
        this.types = types;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public javax.xml.namespace.NamespaceContext getNamespaces() {
        return this.namespaceContext;
    }

    @Override
    public URI getDocumentBaseURI() {
        URI res = null;
        try {
            if (this.baseURI.getPath().lastIndexOf("/") != -1) {
                res = new URI(this.baseURI.getPath().substring(0, this.baseURI.getPath().lastIndexOf("/") + 1));
            }
        }
        catch (URISyntaxException e) {
            log.warning("BaseURI is null : " + this.baseURI);
        }
        return res;
    }

    @Override
    public void setDocumentBaseURI(URI documentBaseURI) {
        this.baseURI = documentBaseURI;
    }

    @Override
    public Map<String, String> getSchemaLocation() {
        return this.schemaLocations;
    }

    @Override
    public String toString() {
        return this.baseURI.toString();
    }
}

