/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.wsdl.api.abstractElmt;

import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import com.ebmwebsourcing.commons.schema.util.Util;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.Include;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractDescriptionImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DescriptionImpl;
import com.ebmwebsourcing.commons.wsdl.impl.wsdl20.WSDLReaderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIncludeImpl<E>
extends AbstractWSDLElementImpl<E>
implements Include {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(AbstractIncludeImpl.class.getName());
    protected Description desc;
    protected Description parent;

    public AbstractIncludeImpl(E model, Description parent) {
        this.model = model;
        this.parent = parent;
        String location = this.getLocationURI();
        if (!Util.isURL((String)location) && parent.getDocumentBaseURI() != null) {
            location = parent.getDocumentBaseURI().getPath() + location;
        }
        if (this.parent != null && ((AbstractDescriptionImpl)this.parent).getFeatures() != null && ((Boolean)((AbstractDescriptionImpl)this.parent).getFeatures().get((Object)WSDLReader.FeatureConstants.IMPORT_DOCUMENTS)).booleanValue()) {
            this.retrieveInclude(location);
        }
        if (this.parent != null && this.desc != null) {
            ((AbstractDescriptionImpl)this.desc).setFeatures(((AbstractDescriptionImpl)this.parent).getFeatures());
        }
    }

    private void retrieveInclude(String location) {
        if (location != null) {
            InputStream is = null;
            try {
                URI loc = new URI(location);
                File f = new File(location);
                is = f.exists() ? new FileInputStream(new File(location)) : loc.toURL().openStream();
                AbstractWSDLReaderImpl reader = null;
                if (this.parent instanceof com.ebmwebsourcing.commons.wsdl.impl.wsdl11.DescriptionImpl) {
                    reader = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.WSDLReaderImpl();
                } else if (this.parent instanceof DescriptionImpl) {
                    reader = new WSDLReaderImpl();
                }
                if (reader != null) {
                    ((AbstractWSDLReaderImpl)reader).setFeatures(((AbstractDescriptionImpl)this.parent).getFeatures());
                    this.desc = reader.readWSDL(loc, SourceHelper.convertInputSource2DOMSource((InputSource)new InputSource(is)));
                }
            }
            catch (MalformedURLException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (URISyntaxException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (UnknownHostException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (ConnectException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (IOException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (WSDLException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
            catch (XmlException e) {
                log.warning("the imported document cannot be import at: " + location + " => " + e.getMessage());
            }
        }
    }

    @Override
    public Description getDescription() {
        return this.desc;
    }

    @Override
    public void setDescription(Description desc) {
        this.desc = desc;
    }

    public Description getParentDescription() {
        return this.parent;
    }

    public void setParentDescription(Description parent) {
        this.parent = parent;
    }
}

