/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.wsdl.impl.generic;

import com.ebmwebsourcing.commons.schema.api.XmlException;
import com.ebmwebsourcing.commons.schema.util.SourceHelper;
import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.WSDLReader;
import com.ebmwebsourcing.commons.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import com.ebmwebsourcing.commons.wsdl.util.Constants;
import com.ebmwebsourcing.commons.wsdl.util.WSDLJDomAnalyzer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.dom.DOMSource;
import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WSDLReaderImpl
extends AbstractWSDLReaderImpl
implements WSDLReader {
    public Description readWSDL(URI wsdlURI) throws WSDLException {
        Description desc = null;
        try {
            InputStream source = null;
            File f = new File(wsdlURI.getPath());
            source = f.exists() ? new FileInputStream(f) : wsdlURI.toURL().openStream();
            desc = this.readWSDL(wsdlURI, SourceHelper.convertInputSource2DOMSource((InputSource)new InputSource(source)));
        }
        catch (MalformedURLException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        catch (IOException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        catch (WSDLException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        catch (XmlException e) {
            throw new WSDLException("Can not get wsdl at: " + wsdlURI, e);
        }
        return desc;
    }

    private WSDLReader getConcreteReader(DOMSource input) throws WSDLException {
        AbstractWSDLReaderImpl reader = null;
        try {
            this.analyzer = new WSDLJDomAnalyzer(SourceHelper.convertDOMSource2InputSource((DOMSource)input));
            Constants.WSDLVersionConstants version = this.analyzer.getVersion();
            if (version == Constants.WSDLVersionConstants.WSDL11) {
                reader = new com.ebmwebsourcing.commons.wsdl.impl.wsdl11.WSDLReaderImpl();
            } else if (version == Constants.WSDLVersionConstants.WSDL20) {
                reader = new com.ebmwebsourcing.commons.wsdl.impl.wsdl20.WSDLReaderImpl();
            } else {
                throw new WSDLException("unknown version of wsdl");
            }
            ((AbstractWSDLReaderImpl)reader).setFeatures(this.getFeatures());
        }
        catch (JDOMException e) {
            throw new WSDLException("unknown version of wsdl", e);
        }
        catch (XmlException e) {
            throw new WSDLException("unknown version of wsdl", e);
        }
        return reader;
    }

    public Description readWSDL(Document wsdlDocument) throws WSDLException {
        Description desc = null;
        DOMSource domSource = new DOMSource(wsdlDocument);
        try {
            if (wsdlDocument.getDocumentURI() == null) {
                throw new WSDLException("document uri cannot be null");
            }
            desc = this.readWSDL(new URI(wsdlDocument.getDocumentURI()), domSource);
        }
        catch (URISyntaxException e) {
            throw new WSDLException(e);
        }
        return desc;
    }

    public Description readWSDL(URI wsdlURI, DOMSource inputSource) throws WSDLException {
        Description desc = null;
        try {
            DOMSource source1 = SourceHelper.cloneSource((DOMSource)inputSource);
            DOMSource source2 = SourceHelper.cloneSource((DOMSource)inputSource);
            WSDLReader reader = this.getConcreteReader(source1);
            ((AbstractWSDLReaderImpl)reader).setAnalyzer(this.analyzer);
            desc = reader.readWSDL(wsdlURI, source2);
        }
        catch (XmlException e) {
            throw new WSDLException(e);
        }
        return desc;
    }
}

