/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.wsdl.impl.wsdl20;

import com.ebmwebsourcing.commons.wsdl.api.Description;
import com.ebmwebsourcing.commons.wsdl.api.WSDLException;
import com.ebmwebsourcing.commons.wsdl.api.WSDLWriter;
import com.ebmwebsourcing.commons.wsdl.impl.wsdl20.DescriptionImpl;
import com.ebmwebsourcing.commons.wsdl.impl.wsdl20.WSDLJAXBContext;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.NotImplementedException;
import org.w3.ns.wsdl.DescriptionType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSDLWriterImpl
implements WSDLWriter {
    private static Marshaller marshaller = null;
    private static WSDLException marshallerCreationEx = null;

    private static Document convertWSDL20Description2DOMElement(DescriptionType wsdlDescriptor) throws WSDLException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            JAXBElement element = new JAXBElement(new QName("http://www.w3.org/ns/wsdl", "description"), wsdlDescriptor.getClass(), (Object)wsdlDescriptor);
            marshaller.marshal((Object)element, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new WSDLException("Failed to build XML binding from WSDL descriptor Java classes", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new WSDLException("Failed to build XML binding from WSDL descriptor Java classes", ex);
        }
        return doc;
    }

    private static String convertWSDL20Description2String(DescriptionType wsdlDescriptor) throws WSDLException {
        try {
            StringWriter stringWriter = new StringWriter();
            JAXBElement element = new JAXBElement(new QName("http://www.w3.org/ns/wsdl", "description"), wsdlDescriptor.getClass(), (Object)wsdlDescriptor);
            marshaller.marshal((Object)element, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new WSDLException("Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }

    public static Marshaller getMarshaller() throws WSDLException {
        if (marshallerCreationEx != null) {
            throw marshallerCreationEx;
        }
        return marshaller;
    }

    public Document getDocument(Description wsdlDef) throws WSDLException {
        Document doc = null;
        if (wsdlDef != null && wsdlDef instanceof DescriptionImpl) {
            try {
                doc = WSDLWriterImpl.convertWSDL20Description2DOMElement((DescriptionType)((DescriptionImpl)wsdlDef).getModel());
                doc.setDocumentURI(wsdlDef.getDocumentBaseURI().getPath());
            }
            catch (WSDLException e) {
                throw new WSDLException("Can not write wsdl description", e);
            }
        }
        return doc;
    }

    public boolean getFeature(String name) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    public String writeWSDL(Description wsdlDef) throws WSDLException {
        String res = null;
        if (wsdlDef != null && wsdlDef instanceof DescriptionImpl) {
            try {
                res = WSDLWriterImpl.convertWSDL20Description2String((DescriptionType)((DescriptionImpl)wsdlDef).getModel());
            }
            catch (WSDLException e) {
                throw new WSDLException("Can not write wsdl description", e);
            }
        }
        return res;
    }

    static {
        try {
            WSDLJAXBContext.createContext();
            marshaller = WSDLJAXBContext.getJaxbContext().createMarshaller();
        }
        catch (JAXBException e) {
            WSDLException schemaCreationEx = new WSDLException("Failed to get resources 'schema/wsdl/wsdl20/wsdl20.xsd'", e);
            marshallerCreationEx = new WSDLException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
        catch (WSDLException e) {
            WSDLException schemaCreationEx = new WSDLException("Failed to get resources 'schema/wsdl/wsdl20/wsdl20.xsd'", e);
            marshallerCreationEx = new WSDLException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
    }
}

