package com.ebmwebsourcing.easybox.api;

/**
 * Interface to be implemented by classes allowed to create instances of
 * {@link XmlObject}.
 * 
 * @author mjambert
 * 
 */
public interface XmlObjectBinding {

    
    /**
     * Get unique name of this binding.
     * 
     * @return Name of this binding.
     */
    String getName();
    
    /**
     * Get array of classes for which this factory delegate can factor
     * objects.
     * 
     * @return Array of {@link XmlObject} implementation classes.
     */
    Class<? extends XmlObjectNode>[] getFactorableClasses(); 


    
    /**
     * Return whether or not this delegate can wrap a given internal model object.
     * 
     * @param obj
     *            Object to be wrapped into an {@link XmlObject}.
     * @return {@code true} if this delegate can wrap {@code obj}, {@code false} otherwise.
     */
    boolean canWrap(Object obj);

    /**
     * Wrap an internal model object into an implementation of {@link XmlObject}
     * .
     * 
     * @param <X>
     *            Type of desired {@link XmlObject} implementation.
     * @param xmlContext Associated {@link XmlContext}.
     * @param xmlObjectImplClass
     *            Concrete class to be instantiated.
     * @param obj
     *            Model object to be wrapped.
     * @return Newly created {@link XmlObject}.
     */
    <X extends XmlObjectNode> X wrap(XmlContext xmlContext, Class<X> xmlObjectImplClass, Object obj);

    /**
     * Wrap any internal model object into an {@link XmlObject}, guessing the
     * proper {@link XmlObject} implementation.
     * 
     * @param xmlContext Associated {@link XmlContext}.
     * @param obj
     *            Model object to be wrapped.
     * @return Newly created {@link XmlObject}.
     */
    XmlObjectNode wrap(XmlContext xmlContext, Object obj);

    /**
     * Create a new {@link XmlObject}.
     * 
     * @param <X>
     *            Type of desired {@link XmlObject} implementation.
     * @param xmlContext Associated {@link XmlContext}.
     * @param xmlObjectImplClass
     *            Concrete class to be instantiated.
     * @return Newly created concrete {@link XmlObject}.
     */
    <X extends XmlObjectNode> X create(XmlContext xmlContext, Class<X> xmlObjectImplClass);


    
    
}
