/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.List;

import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.CatchValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class CatchValidatorImpl implements CatchValidator {

	private Catch _catch = null;

	public CatchValidatorImpl(final Catch _catch) {
		this._catch = _catch;
	}

	public void validate() {
		// validation

		// validation if empty
		if((this._catch.getFaultName() != null) && (this._catch.getFaultName().toString().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._catch, new BPELException("In catch => the faultName cannot be empty")));
		}
		if((this._catch.getFaultVariable() != null) && (this._catch.getFaultVariable().toString().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._catch, new BPELException("In catch => the faultVariable cannot be empty")));
		}
		if((this._catch.getFaultMessageType() != null) && (this._catch.getFaultMessageType().toString().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._catch, new BPELException("In catch => the faultMessageType cannot be empty")));
		}
		if((this._catch.getFaultElement() != null) && (this._catch.getFaultElement().toString().trim().length() == 0)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._catch, new BPELException("In catch => the faultElement cannot be empty")));
		}
		
		if((this._catch.getFaultElement() != null) && (this._catch.getFaultMessageType() != null)) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._catch, new BPELException("In catch => Impossible to define both faultElement and faultMessageType")));
		}

		//validation on content
		final BPELProcess process = ScopeUtil.getProcess((this._catch));

		// find if message exist
		if(this._catch.getFaultMessageType() != null) {
			final MessageImpl msg = process.getImports().getMessage(this._catch.getFaultMessageType());
			if(msg == null) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._catch, new BPELException("In catch => Impossible to find message \"" + this._catch.getFaultMessageType() + "\"")));
			}
		}

		// find if element exist
		if(this._catch.getFaultElement() != null) {
			final List<org.ow2.easywsdl.schema.api.Element> elmts = process.getImports().findElementsInAllSchema(this._catch.getFaultElement());
			if((elmts == null)||(elmts.size() == 0)) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this._catch, new BPELException("In catch => Impossible to find element \"" + this._catch.getFaultElement() + "\"")));
			}
		}

	}

}
