/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Property;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PropertyAlias;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.VariablePart;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TQuery;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.QueryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.VariablePartImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ParseException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.util.ExpressionUtil;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELCorrelationMatcher implements CorrelationMatcher {

	private Logger log = Logger.getLogger(BPELCorrelationMatcher.class.getName());

	private final Descriptions desc;

	private final BPELProcess bpeldefinition;

	private final List<Correlation> correlations;

	private QName variableToCorrelate = null;

	public BPELCorrelationMatcher(final BPELProcess bpeldefinition, final List<Correlation> correlations,  final QName inputVariable) {
		this.desc = bpeldefinition.getImports();
		this.bpeldefinition = bpeldefinition;
		this.correlations = correlations;
		this.variableToCorrelate = inputVariable;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

	public boolean match(final Scope scope, final QName variableName,
			final InternalMessage<?> message) throws CoreException {
		boolean res = false;
		try {
			// verif variable
			if(this.variableToCorrelate.equals(variableName)) {

				// get variable from
				final BPELVariable varFrom = (BPELVariable) scope.findVariable(this.variableToCorrelate);
				if(varFrom == null) {
					throw new CoreException("Impossible to find variable corresponding to this name " + this.variableToCorrelate);
				}

				List<CorrelationGroup> correlationGroups = new ArrayList<CorrelationGroup>();
				if(this.correlations != null) {
					this.log.finest("get specific correlations");
					for(final Correlation corr: this.correlations) {
						correlationGroups.addAll(scope.findCorrelationGroups(corr.getSet()));
					}
				} else {
					this.log.finest("get global correlations on the scope: " + scope.getName());
					correlationGroups = scope.getProcess().getCorrelationGroups();
				}

				this.log.finest("correlationGroups size: " + correlationGroups.size());
				if(correlationGroups.size() > 0) {
					for(final CorrelationGroup correlationGroup:  correlationGroups) {
						// get correlation
						for(final Entry<String, com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation> correlation: correlationGroup.getCorrelations().entrySet()) {
							// find CorrelationSet
							final CorrelationSet correlationSet = this.bpeldefinition.getCorrelationSet(correlation.getKey());
							if(correlationSet == null) {
								throw new CoreException("Impossible to find the correlation set corresponding to this name " + correlation.getKey());
							}
							this.log.finest("control correlation: " + correlationSet.getName());
							

							// find corresponding properties
							final List<QName> propertiesName = correlationSet.getProperties();
							for(final QName propertyName: propertiesName) {

								final Property prop = this.desc.getProperty(propertyName);
								if(prop == null) {
									throw new BPELException("Impossible to find property corresponding to this name " + propertyName);
								}

								final com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation corr = correlation.getValue();
								final To to = (To) corr.getOriginator();
								// get variable to
								final Variable varTo = scope.findVariable(new QName(to.getVariableProperty().getVariable()));
								if(varTo == null) {
									throw new CoreException("Impossible to find variable corresponding to this name " + to.getVariableProperty().getVariable());
								}

								final From from = (From) corr.getFollower();

								final PropertyAlias propAliasTo = this.findCorrespondingPropertiesAlias(prop.getQName(), (BPELVariable) varTo);
								if(propAliasTo == null) {
									throw new BPELException("Error to correlate initial variable with property: " + prop.getQName());
								}
								final TQuery queryTo = new TQuery();
								queryTo.getContent().add(propAliasTo.getQuery().getContentString());
								queryTo.setQueryLanguage(propAliasTo.getQuery().getQueryLanguage());
								final VariablePart vTO = new VariablePartImpl(new QName(to.getVariableProperty().getVariable()), propAliasTo.getPart(), new QueryImpl(queryTo, to));

								final PropertyAlias propAliasFrom = this.findCorrespondingPropertiesAlias(prop.getQName(), varFrom);
								if(propAliasFrom == null) {
									throw new BPELException("Error to correlate final variable with property: " + prop.getQName());
								}
								final TQuery queryFrom = new TQuery();
								queryFrom.getContent().add(propAliasFrom.getQuery().getContentString());
								queryFrom.setQueryLanguage(propAliasFrom.getQuery().getQueryLanguage());
								final VariablePart vFrom = new VariablePartImpl(this.variableToCorrelate, propAliasFrom.getPart(), new QueryImpl(queryFrom, from));
								varFrom.setValue(message);

								final String expressionTo = ExpressionUtil.convertVariable2Expression(vTO);

								final String expressionFrom = ExpressionUtil.convertVariable2Expression(vFrom);

								final String conditionnalExpression = expressionTo + "=" + expressionFrom;
								this.log.finest("Correlation conditional expression found: " + conditionnalExpression);

								final AbsItfDescription descTo = (AbsItfDescription) ((AbstractWSDLElementImpl)propAliasTo).getTopParent(); 
								final AbsItfDescription descFrom = (AbsItfDescription) ((AbstractWSDLElementImpl)propAliasFrom).getTopParent(); 
								
								
								final NamespaceMapperImpl nsList = new NamespaceMapperImpl();
								if(descTo == descFrom) {
									for(final Entry<String, String> entry: descTo.getNamespaces().getNamespaces().entrySet()) {
										if(!this.bpeldefinition.getNamespaceContext().getNamespaces().containsKey(entry.getKey())) {
											nsList.addNamespace(entry.getKey(), entry.getValue());
										} else {
											this.log.warning("The bpel definition contains already this prefix: " + entry.getKey());
										}
									}
								} else {
									for(final Entry<String, String> entry: descTo.getNamespaces().getNamespaces().entrySet()) {
										if(!this.bpeldefinition.getNamespaceContext().getNamespaces().containsKey(entry.getKey())) {
											nsList.addNamespace(entry.getKey(), entry.getValue());
										} else {
											this.log.warning("The bpel definition contains already this prefix: " + entry.getKey());
										}
									}
									for(final Entry<String, String> entry: descFrom.getNamespaces().getNamespaces().entrySet()) {
										if(!this.bpeldefinition.getNamespaceContext().getNamespaces().containsKey(entry.getKey())) {
											nsList.addNamespace(entry.getKey(), entry.getValue());
										} else {
											this.log.warning("The bpel definition contains already this prefix: " + entry.getKey());
										}
									}
								}
								
								final ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(conditionnalExpression);
								final ASTStart n = expressionAnalyzer.Start();
								final ExpressionVisitor ev = new ExpressionDumpVisitor(scope, this.bpeldefinition, nsList);
								if(!this.log.getName().equals(BPELCorrelationMatcher.class.getName())) {
									((ExpressionDumpVisitor)ev).setLog(this.log);
								}
								final Element condition = n.jjtAccept(ev, null);

								this.log.finest("condition = " + condition.getText());
								if(condition.getText().equals("true")) {
									res = true;
								} else {
									res = false;
									varFrom.setValue(null);
								}
							}
						}
					}
				} else {
					res = true;
				}
			}
		} catch (final WSDL4BPELException e) {
			throw new CoreException(e);
		} catch (final BPELException e) {
			throw new CoreException(e);
		} catch (final ParseException e) {
			throw new CoreException(e);
		}
		return res;
	}

	private PropertyAlias findCorrespondingPropertiesAlias(final QName propertyName, final BPELVariable var) throws BPELException {
		PropertyAlias res = null;
		try {
			// find corresponding propertiesAlias
			List<PropertyAlias> propertiesAliases;

			propertiesAliases = this.desc.getPropertyAliases4ThisProperty(propertyName);

			if(propertiesAliases != null) {

				for(final PropertyAlias propertyAlias: propertiesAliases) {


					// math correlation with variable
					boolean correlationMatching = false;
					
					if((propertyAlias.getElement() != null)&&(propertyAlias.getElement().equals(var.getElement()))) {
						correlationMatching = true;
					} else if((propertyAlias.getMessageType() != null)&&(propertyAlias.getMessageType().equals(var.getMessageType()))) {
						correlationMatching = true;
					} else if((propertyAlias.getType() != null)&&(propertyAlias.getType().equals(var.getTypeQName()))) {
						correlationMatching = true;
					} 

					if(correlationMatching) {
						res = propertyAlias;
						break;
					} 
				}
			}
		} catch (final WSDL4BPELException e) {
			throw new BPELException(e);
		}


		return res;
	}


}
