/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Role;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.extension.Extensions;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader.FeatureConstants;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELWriter;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELIntVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLinks;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariables;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.extension.ExtensionActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationSetImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.extension.ExtensionsImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.fault.FaultHandlersImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.PartnerLinkImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELElementVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELIntVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports.ImportImpl;
import com.ebmwebsourcing.easyviper.core.api.Core;



/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=BPELProcess.class,names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class BPELProcessImpl extends BPELElementImpl<TProcess> implements BPELProcess {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(BPELProcessImpl.class.getName());

	private final URI baseURI;

	private static BPELWriter writer = null;
	private static BPELException writerEx = null;

	private static BPELReader reader = null;

	private static BPELException readerEx = null;

	static {
		BPELFactory factory = null;
		factory = BPELFactoryImpl.getInstance();


		if(factory != null) {
			try {
				writer = factory.newBPELWriter();
			} catch (final BPELException e) {
				writerEx = e;
			}

			try {
				reader = factory.newBPELReader();
			} catch (final BPELException e) {
				readerEx = e;
			}
		}
	}

	public static BPELWriter getWriter() throws BPELException {
		if(writerEx != null) {
			throw writerEx;
		}
		return writer;
	}


	public static BPELReader getReader()  throws BPELException {
		if(readerEx != null) {
			throw readerEx;
		}
		return reader;
	}

	/**
	 * the namespace context
	 */
	protected NamespaceMapperImpl namespaceContext;


	private final Descriptions descriptions;

	private Activity activity;

	private Extensions extensions;

	private final List<BPELVariable> variables = new ArrayList<BPELVariable>();

	private final List<PartnerLink> partnerLinks = new ArrayList<PartnerLink>();

	private final List<CorrelationSet> correlationsets = new ArrayList<CorrelationSet>();

	private FaultHandlers faultHandlers = null;



	public BPELProcessImpl(final URI baseURI, final TProcess process, final NamespaceMapperImpl context,
			final Map<FeatureConstants, Object> features)  {
		super(Constants._Process_QNAME, process, null);
		this.baseURI = baseURI;

		// create writer
		try {
			BPELProcessImpl.getWriter();
		} catch (final BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		}

		// create reader
		try {
			BPELProcessImpl.getReader();
		} catch (final BPELException e) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		}

		this.namespaceContext = context;

		// get imports
		final List<Import> imports = new ArrayList<Import>();
		if((this.model.getImport() != null)&&(this.model.getImport().size() > 0)) {
			for(final TImport impt: this.model.getImport()) {
				imports.add(new ImportImpl(impt, this));
			}
		}

		this.descriptions = new Descriptions(this.model.getTargetNamespace(), this.model.getName(), imports);
		
		// get extensions
		if(this.model.getExtensions() != null && this.model.getExtensions().getExtension().size() > 0) {
			this.extensions = new ExtensionsImpl(this.model.getExtensions(), this);
		}

		// get partnerLinks
		if(this.model.getPartnerLinks() != null) {
			if((this.model.getPartnerLinks().getPartnerLink() != null)&&
					(this.model.getPartnerLinks().getPartnerLink().size() > 0)) {
				for(final TPartnerLink partner: this.model.getPartnerLinks().getPartnerLink()) {
					this.partnerLinks.add(new PartnerLinkImpl(partner, this.model.getPartnerLinks(), this));
				}
			}
		}

		// get variables
		try {
			this.variables.addAll(ScopeImpl.extractVariablesInModel(this.model.getVariables(), this));
		} catch (final BPELException e) {

			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		}

		// get faultHandlers
		if(this.model.getFaultHandlers() != null) {
			this.faultHandlers = new FaultHandlersImpl(this.model.getFaultHandlers(), this);
		}

		// get correlation set
		try {
			this.correlationsets.addAll(CorrelationSetImpl.extractCorrelationSetsInModel(this.model.getCorrelationSets(), this));
		} catch (final BPELException e) {

			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		}

		// get activity
		try {
			this.activity = ActivityImpl.analyzeProcess(this.model, this);
			// get extension activity
			if(this.activity == null && this.model.getExtensionActivity() != null) {
				this.activity = new ExtensionActivityImpl(this.model.getExtensionActivity(), this);
			}
		} catch (final BPELException e) {

			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		} 


	}


	public URI getDocumentBaseURI() {
		URI res = null;
		res = URI.create(this.baseURI.toString().substring(0,
										this.baseURI.toString().lastIndexOf("/") + 1));
		return res;
	}

	public String getName() {
		return this.model.getName();
	}

	public void setName(final String name) {
		this.model.setName(name);
	}

	public String getDescription() {
		String res = null;
		try {
			res = BPELProcessImpl.getWriter().writeBPEL(this);
		} catch (final BPELException e) {
			// do nothing
		}
		return res;
	}


	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new XmlException("Not yet implemented");
	}


	@Override
	public Map<QName, String> getOtherAttributes() throws XmlException {
		return this.model.getOtherAttributes();
	}


	public Activity getActivity() {
		return this.activity;
	}


	public Descriptions getImports() {
		return this.descriptions;
	}
	
	@Override
	public void addImport(Import impt){
		if(impt!=null){
			descriptions.addImport(impt);
			this.model.getImport().add((TImport) ((AbstractSchemaElementImpl)impt).getModel());
		}
	}
	
	@Override
	public void removeImport(Import impt){
		if(impt!=null){
			descriptions.removeImport(impt);
			this.model.getImport().remove((TImport) ((AbstractSchemaElementImpl)impt).getModel());
		}
	}

	public QName getQName() {
		QName res = null; 
		if(this.model.getName() != null) {
			res = new QName(this.model.getTargetNamespace(), this.model.getName());
		}
		return res;
	}


	public Sources getSources() {
		return null;
	}


	public boolean getSuppressJoinFailure() {
		return false;
	}


	public Targets getTargets() {
		return null;
	}

	public void addVariable(final BPELVariable variable) {
		this.variables.add(variable);
		this.model.getVariables().getVariable().add((TVariable) ((AbstractSchemaElementImpl)variable).getModel());
	}

	public List<BPELVariable> getVariables() {
		return this.variables;
	}
	

	
	
	public NamespaceMapperImpl getNamespaceContext() {
		return this.namespaceContext;
	}

	public PartnerLink getPartnerLink(final String name) {
		PartnerLink res = null;
		for(final PartnerLink partner: this.partnerLinks) {
			if(partner.getName().equals(name)) {
				res = partner;
				break;
			}
		}
		return res;
	}

	public List<PartnerLink> getPartnerLinks() {
		return this.partnerLinks;
	}

	public CorrelationSet getCorrelationSet(final String name) {
		CorrelationSet res = null;
		for(final CorrelationSet corr: this.correlationsets) {
			if(corr.getName().equals(name)) {
				res = corr;
				break;
			}
		}
		return res;
	}

	public List<CorrelationSet> getCorrelationSets() {
		return this.correlationsets;
	}

	public FaultHandlers getFaultHandlers() {
		return this.faultHandlers;
	}


	public BPELVariable findVariable(final QName name) {
		return ScopeImpl.findVariable(name, this.variables, null);
	}
	

	public PartnerLink findPartnerLink(final String name) {
		PartnerLink res = null;
		for(final PartnerLink p: this.partnerLinks) {
			if(p.getName().equals(name)) {
				res = p;
				break;
			}
		}
		return res;
	}


	public String getTargetNamespace() {
		return this.model.getTargetNamespace();
	}


	public void setTargetNamespace(final String ns) {
		this.model.setTargetNamespace(ns);
	}


	public Extensions getExtensions() {
		return this.extensions;
	}


	public void setActivity(Activity activity) throws BPELException {
		this.activity = activity;
		//Set the internal JAXB model
		try {
			ActivityImpl.setActivityToProcess(activity, this);
		} catch (BPELException e) {
			throw new BPELException(e);
		}
	}


	public PartnerLink createPartnerLink() {
		TPartnerLinks partners = this.model.getPartnerLinks();
		if(partners == null){
			partners = new TPartnerLinks();
			this.model.setPartnerLinks(partners);
		}

		TPartnerLink tpartner = new TPartnerLink();
		this.model.getPartnerLinks().getPartnerLink().add(tpartner);
		PartnerLinkImpl partner = new PartnerLinkImpl(tpartner, this.model.getPartnerLinks(), this);
		this.getPartnerLinks().add(partner);
		return partner;
	}

	public BPELIntVariable createBPELIntVariable(String varName, QName e){
		TVariable tvar = new TVariable();
		tvar.setName(varName);
		tvar.setType(e);
		
		TVariables tvars = this.model.getVariables();
		if(tvars == null){
			tvars = new TVariables();
			this.model.setVariables(tvars);
		}
		
		this.model.getVariables().getVariable().add(tvar);
		BPELIntVariable var = new BPELIntVariableImpl(tvar, this.model.getVariables(), this);
		
		return var;
	}
	
	public BPELElementVariable createBPELElementVariable(String varName, QName e, BPELElementVariable.VariableType varType){
		
		
		TVariable tvar = new TVariable();
		tvar.setName(varName);
		//TODO switch to if
		switch( varType ){
		case MESSAGE:
			tvar.setMessageType(e);
			break;
		case ELEMENT:
			tvar.setElement(e);
			break;
		case TYPE:
			tvar.setType(e);
		}
		
		TVariables tvars = this.model.getVariables();
		if(tvars == null){
			tvars = new TVariables();
			this.model.setVariables(tvars);
		}
		
		BPELElementVariable var = new BPELElementVariableImpl(tvar, this.model.getVariables(), this); 
		this.addVariable(var);
		return var;
	}


    public List<Interface> getProcessInterfaces() {
        List<Interface> interfaces = new ArrayList<Interface>();
        for (PartnerLink partnerLink : partnerLinks) {
            if (partnerLink.getMyRole() != null) {
                Role myRole = getImports().getPartnerLinkType(partnerLink.getPartnerLinkType()).getRole(partnerLink.getMyRole());
                assert myRole != null;
                interfaces.add(getImports().findInterface(myRole.getInterfaceQName()));
            }
        }
        return interfaces;
    }

}
