/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.oasisopen.sca.annotation.PolicySets;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Property;
import org.petalslink.abslayer.service.api.PropertyAlias;
import org.petalslink.abslayer.service.api.Role;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybpel.extended.service.activity.impl.ExtendedActivityServiceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Exit;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ReThrow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.RepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Throw;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.BPELCompiler;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.CatchAll;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInitiate;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTo;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.AssignImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ForEachImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.ToImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.VariablePropertyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.BuiltInException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELAssigner;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELCorrelationMatcher;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELFaultHandler;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELMessageMatcher;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SOAPAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELElementVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELIntVariableImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELAssignementExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELBooleanExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELAssignementExpressionImpl;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AssignBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReThrowBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ThrowBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.DateExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.AssignBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ExitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReThrowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SenderBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ThrowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.WaitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.fault.FaultImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.soa.EndpointImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.correlation.CorrelationGroupImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = BPELCompiler.class, names = "service")
@PolicySets("frascati:scaEasyPrimitive")
public class BPELCompilerImpl extends AbstractCompiler<BPELProcess> implements
        BPELCompiler {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    BPELReader reader;

    DocumentBuilderFactory factory;

    private Logger log = Logger.getLogger(BPELCompilerImpl.class.getName());

    public BPELCompilerImpl() throws BPELException {
        this.reader = BPELFactoryImpl.getInstance().newBPELReader();
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public String convertStreamToString(final InputStream is) {
        /*
         * To convert the InputStream to String we use the
         * BufferedReader.readLine() method. We iterate until the BufferedReader
         * return null which means there's no more data to read. Each line will
         * appended to a StringBuilder and returned as String.
         */
        final BufferedReader reader = new BufferedReader(new InputStreamReader(
                is));
        final StringBuilder sb = new StringBuilder();

        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        } catch (final IOException e) {
            e.printStackTrace();
        } finally {
            try {
                is.close();
            } catch (final IOException e) {
                e.printStackTrace();
            }
        }

        return sb.toString();
    }

    @Override
    public BPELProcess validate(final URI uri) throws CoreException {
        // create syntactic tree

        BPELProcess bpelprocess = null;
        try {

            // clean static analysis
            BPELStaticAnalysisImpl.getInstance().getErrors().clear();
            BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
            BPELStaticAnalysisImpl.getInstance().getInfos().clear();

            // FIX JAXB BUG ON YES AND NO ENUMERATION
            URL url = null;
            InputStream is = null;
            if (uri.isAbsolute()) {
            	url = uri.toURL();
            } else {
            	url = new URL(new File(".").toURI().toURL(), uri.toString()); 
            }
            is = url.openStream(); 

            final Document bpelSrcDoc = this.factory.newDocumentBuilder()
                    .parse(is);
            final Document bpeltargetDoc = bpelSrcDoc;// DoXslTransformFunctionImpl.process(

            if (bpeltargetDoc.getDocumentURI() == null) {
            	bpeltargetDoc.setDocumentURI(url.toString().replaceAll(" ", "%20")); 
            }
            // END OF FIX BUGS

            bpelprocess = this.reader.readBPEL(bpeltargetDoc);

            // Core configuration validation
            if (bpelprocess.getExtensions() != null
                    && bpelprocess.getExtensions().getExtensions() != null
                    && bpelprocess.getExtensions().getExtensions().size() > 0) {
                Service service = this.getModel().getCore().getEngine()
                        .getServiceManager()
                        .getService(ExtendedActivityServiceImpl.class);
                if (service == null) {
                    throw new CoreException(
                            "Sorry, but the extended Service Manager is not plugged to engine!!!");
                }

            }
        } catch (final BPELException e) {
            throw new CoreException(e);
        } catch (final MalformedURLException e) {
            throw new CoreException(e);
        } catch (final IOException e) {
            throw new CoreException(e);
        } catch (final SAXException e) {
            throw new CoreException(e);
        } catch (final ParserConfigurationException e) {
            throw new CoreException(e);
        } 

        // TODO: create symbol type

        // TODO: type verification

        return bpelprocess;
    }

    public Process generate(final Core core, final BPELProcess bpelprocess)
            throws BPELException {
        Process process = null;

        if (core == null) {
            throw new BPELException("Core MUST not be null");
        }

        try {
            process = this.compile(bpelprocess);
        } catch (final CoreException e) {
            throw new BPELException(e);
        }

        return process;
    }

    @Override
    public Process compile(final BPELProcess bpelProcessDefinition)
            throws CoreException {
        Process process = null;
        try {
            if (bpelProcessDefinition == null) {
                throw new CoreException("bpel process cannot be null !!!");
            }
            this.log.finest("start the compilation");
            process = this
                    .getModel()
                    .getCore()
                    .getEngine()
                    .createNewEmptyProcessInstance(
                            new QName(bpelProcessDefinition.getQName() + "_"
                                    + System.nanoTime()), bpelProcessDefinition);
            BPELAssigner bpelAssigner = new BPELAssigner(bpelProcessDefinition);
            bpelAssigner.setLog(this.log);
            process.setAssigner(bpelAssigner);

            this.log.finest("empty process create");
            Node initial = null;

            // affect variables in process
            this.affectVariablesInScope(bpelProcessDefinition,
                    bpelProcessDefinition, process);

            // register all partners
            for (final PartnerLink plt : bpelProcessDefinition
                    .getPartnerLinks()) {
                process.getEndpoints().put(plt, new EndpointImpl());
            }

            // generate process
            if (bpelProcessDefinition.getActivity() != null) {
                initial = this.generateActivity(process,
                        bpelProcessDefinition.getActivity(),
                        bpelProcessDefinition);
            }

            // add all catchs in scope
            if (bpelProcessDefinition.getFaultHandlers() != null) {
                this.generateFaultHandlers(process, bpelProcessDefinition
                        .getFaultHandlers().getCatchs(), bpelProcessDefinition
                        .getFaultHandlers().getCatchAll(),
                        bpelProcessDefinition);
            }

            if (initial != null) {
                process.setInitialNode(initial);
            } else {
                throw new CoreException("No main in BPEL process");
            }

            this.log.finest("end of the compilation");
        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return process;
    }

    private void affectVariablesInScope(
            final BPELProcess bpelProcess,
            final com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope scopeDefinition,
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope)
            throws BPELException {
        final MessageMatcher matcher = new BPELMessageMatcher(
                bpelProcess.getImports());
        if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
            matcher.setLog(this.log);
        }
        for (final BPELVariable definition : scopeDefinition.getVariables()) {
            this.addVariableInScope(scope, definition);
        }
    }

    private BPELVariable addVariableInScope(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final BPELVariable definition) throws BPELException {
        final BPELVariable v = (BPELVariable) definition.copypaste();
        scope.getVariables().put(v.getQName(), v);
        return v;
    }

    private Node generateSequence(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Sequence sequence, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate sequence");
        Node sequenceNode = null;
        if (sequence != null) {
            final List<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;
            for (final Activity activity : sequence.getActivities()) {
                activityNode = this.generateActivity(scope, activity,
                        bpelprocess);
                if (activityNode != null) {
                    childNodes.add(activityNode);
                } else {
                    throw new CoreException("Impossible to generate activity: "
                            + activity.getName());
                }
            }

            // TODO Manage non-functional behaviours in process (set to null for
            // now)
            sequenceNode = CreationPatternFactory.getInstance()
                    .createSequencePattern(sequence.getName(), childNodes,
                            scope);

        }
        this.log.finest("end generate sequence");
        return sequenceNode;
    }

    private Node generateFlow(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Flow flow, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate flow");
        Node flowNode = null;
        if (flow != null) {
            final List<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;
            for (final Activity activity : flow.getActivities()) {
                activityNode = this.generateActivity(scope, activity,
                        bpelprocess);
                if (activityNode != null) {
                    childNodes.add(activityNode);
                } else {
                    throw new CoreException("Impossible to generate activity: "
                            + activity.getName());
                }
            }

            flowNode = CreationPatternFactory.getInstance().createForkPattern(
                    flow.getName(), childNodes, scope);

        }
        this.log.finest("end generate flow");
        return flowNode;
    }

    private Node generateIf(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final If if_, final BPELProcess bpelprocess) throws CoreException {
        this.log.finest("start generate if");
        Node ifNode = null;
        if (if_ != null) {
            final List<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;

            // set bpel definition in each expression
            final List<BPELBooleanExpression> conditions = new ArrayList<BPELBooleanExpression>();
            for (final BPELBooleanExpression exp : if_.getConditions()) {
                final BPELBooleanExpression copy = (BPELBooleanExpression) exp
                        .copypaste();
                if (!this.log.getName()
                        .equals(BPELCompilerImpl.class.getName())) {
                    copy.setLog(this.log);
                }
                conditions.add(copy);
            }

            // generate if
            for (final Activity activity : if_.getActivities()) {
                activityNode = this.generateActivity(scope, activity,
                        bpelprocess);
                if (activityNode != null) {
                    childNodes.add(activityNode);
                } else {
                    throw new CoreException("Impossible to generate activity: "
                            + activity + " in if => " + if_.getName());
                }
            }

            ifNode = CreationPatternFactory.getInstance().createIfPattern(
                    if_.getName(), (List) conditions, childNodes, scope);

        }
        this.log.finest("end generate if");
        return ifNode;
    }

    private Node generatePick(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Pick pick, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate pick");
        Node pickNode = null;
        if (pick != null) {
            final List<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;

            final List<ReceiverBehaviour> receivers = new ArrayList<ReceiverBehaviour>();
            // create receiver corresponding to each message
            final MessageMatcher matcher = new BPELMessageMatcher(
                    bpelprocess.getImports());
            for (final OnMessage msg : pick.getOnMessages()) {

                if (msg.getActivity() != null) {
                    // create receiver node
                    final ReceiverBehaviour receiver = new ReceiverBehaviourImpl();
                    receiver.addVariableName(new QName(msg.getInputVariable()));

                    // set message matcher
                    if (!this.log.getName().equals(
                            BPELCompilerImpl.class.getName())) {
                        matcher.setLog(this.log);
                    }
                    receiver.setMessageMatcher(matcher);

                    // set correlation matcher
                    if (!pick.getCreateInstance()) {
                        final BPELCorrelationMatcher correlationMatcher = new BPELCorrelationMatcher(
                                bpelprocess, msg.getCorrelations(), new QName(
                                        msg.getInputVariable()));
                        if (!this.log.getName().equals(
                                BPELCompilerImpl.class.getName())) {
                            correlationMatcher.setLog(this.log);
                        }
                        final List<CorrelationMatcher> corrs = new ArrayList<CorrelationMatcher>();
                        corrs.add(correlationMatcher);
                        receiver.setCorrelationsMatchers(corrs);
                    }

                    receivers.add(receiver);

                    // get activity
                    activityNode = this.generateActivity(scope,
                            msg.getActivity(), bpelprocess);
                    if (activityNode != null) {
                        childNodes.add(activityNode);
                    } else {
                        throw new CoreException(
                                "Impossible to generate activity: "
                                        + msg.getActivity());
                    }
                }
            }

            pickNode = CreationPatternFactory.getInstance()
                    .createSeveralReceiversPattern(pick.getName(), receivers,
                            childNodes, scope);

        }
        this.log.finest("end generate pick");
        return pickNode;
    }

    private Node generateWhile(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final While while_, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate while");
        Node whileNode = null;
        if (while_ != null) {

            // set bpel definition in each expression
            final BPELBooleanExpression copy = (BPELBooleanExpression) while_
                    .getCondition().copypaste();
            if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                copy.setLog(this.log);
            }

            final List<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;
            activityNode = this.generateActivity(scope, while_.getActivity(),
                    bpelprocess);
            if (activityNode != null) {
                childNodes.add(activityNode);
            } else {
                throw new CoreException("Impossible to generate activity: "
                        + while_.getActivity());
            }
            // TODO Manage non-functional behaviours in process (set to null for
            // now)
            whileNode = CreationPatternFactory.getInstance().createLoopPattern(
                    while_.getName(), copy, true, childNodes, scope);

        }
        this.log.finest("end generate while");
        return whileNode;
    }

    private Node generateRepeatUntil(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final RepeatUntil repeatUntil, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate repeat until");
        Node repeatUntilNode = null;
        if (repeatUntil != null) {

            // set bpel definition in each expression
            final BPELBooleanExpression copy = (BPELBooleanExpression) repeatUntil
                    .getCondition().copypaste();
            if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                copy.setLog(this.log);
            }

            final List<Node> childNodes = new ArrayList<Node>();
            Node activityNode = null;
            activityNode = this.generateActivity(scope,
                    repeatUntil.getActivity(), bpelprocess);
            if (activityNode != null) {
                childNodes.add(activityNode);
            } else {
                throw new CoreException("Impossible to generate activity: "
                        + repeatUntil.getActivity());
            }

            // TODO Manage non-functional behaviours in process (set to null for
            // now)
            repeatUntilNode = CreationPatternFactory.getInstance()
                    .createLoopPattern(repeatUntil.getName(), copy, false,
                            childNodes, scope);

        }
        this.log.finest("end generate repeat until");
        return repeatUntilNode;
    }

    private Node generateForEach(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final ForEach forEach_, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate forEach");
        Node topScopeNode = null;
        try {

            if (forEach_ != null) {

                // set log
                Logger logger = null;
                if (!this.log.getName()
                        .equals(BPELCompilerImpl.class.getName())) {
                    logger = this.log;
                }

                // create boolean condition
                final BPELBooleanExpression condition = ForEachImpl
                        .createBooleanExpressionFromStartAndFinalCounterValue(
                                forEach_, bpelprocess, logger);

                final List<Node> childNodes = new ArrayList<Node>();
                Node underScopeNode = null;

                // create top scope
                topScopeNode = CreationPatternFactory.getInstance()
                        .createScopePattern(
                                "topScope4foarEach_" + forEach_.getName() + "_"
                                        + UUID.randomUUID(), scope);
                final com.ebmwebsourcing.easyviper.core.api.engine.Scope topScope = (com.ebmwebsourcing.easyviper.core.api.engine.Scope) topScopeNode
                        .getComponent().getFcInterface("service");

                // add counter variable in top scope
                // add counter variable in default schema
                
                
                XmlObjectFactory factory = SchemaOfSchemas.getSchema().getXmlContext().getXmlObjectFactory();
                final com.ebmwebsourcing.easyschema10.api.element.Schema defaultSchema = factory.create(
                        com.ebmwebsourcing.easyschema10.api.element.Schema.class);
                defaultSchema.setTargetNamespace(bpelprocess
                        .getTargetNamespace());
                final Element counter = factory.create(Element.class);
                counter.setName(forEach_.getCounterName());
                counter.setType(new QName(com.ebmwebsourcing.easyschema10.api.Constants.XMLSCHEMA_NS_URI, "int"));
                defaultSchema.addElement(counter);
                bpelprocess.getImports().addSchema(defaultSchema);

                // add counter variable in scope
                final TVariable model = new TVariable();
                model.setName(counter.getName());
                model.setElement(counter.inferQName());

                final BPELVariable<Integer> v = new BPELIntVariableImpl(model,
                        null, forEach_);
                topScope.getVariables().put(v.getQName(), v);

                // create assign for initialize counter
                final TAssign modelAI = new TAssign();
                modelAI.setName("AssignI");
                final TCopy copyAI = new TCopy();
                modelAI.getCopyOrExtensionAssignOperation().add(copyAI);
                final TFrom fromAI = new TFrom();
                copyAI.setFrom(fromAI);
                final TTo toAI = new TTo();
                copyAI.setTo(toAI);
                fromAI.getContent().add(
                        forEach_.getStartCounterValue().getContent());
                fromAI.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                toAI.getContent().add("$" + forEach_.getCounterName());
                toAI.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                final Assign assignI = new AssignImpl(modelAI, null);

                // add assign in counter
                final Node assignINode = this.generateAssign(topScope, assignI,
                        bpelprocess);
                topScope.setInitialNode(assignINode);

                // create foreach

                // // create under scope of foreach
                if (forEach_.getScope().getName() == null) {
                    forEach_.getScope().setName(
                            "underScopeInForEach_" + forEach_.getName() + "_"
                                    + UUID.randomUUID());
                }
                underScopeNode = this.generateScope(topScope,
                        forEach_.getScope(), bpelprocess);

                // // add under scope in foreach
                if (underScopeNode != null) {
                    childNodes.add(underScopeNode);
                } else {
                    throw new CoreException("Impossible to generate activity: "
                            + forEach_.getScope());
                }

                // // create assign for increment counter
                final TAssign modelAE = new TAssign();
                modelAE.setName("AssignE");
                final TCopy copyAE = new TCopy();
                modelAE.getCopyOrExtensionAssignOperation().add(copyAE);
                final TFrom fromAE = new TFrom();
                copyAE.setFrom(fromAE);
                final TTo toAE = new TTo();
                copyAE.setTo(toAE);
                fromAE.getContent().add(
                        "$" + forEach_.getCounterName() + " + 1");
                fromAE.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                toAE.getContent().add("$" + forEach_.getCounterName());
                toAE.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                final Assign assignE = new AssignImpl(modelAE, null);

                // // add assign in counter
                final Node assignENode = this.generateAssign(topScope, assignE,
                        bpelprocess);
                childNodes.add(assignENode);

                // TODO Manage non-functional behaviours in process (set to null
                // for now)
                final Node forEachNode = CreationPatternFactory.getInstance()
                        .createLoopPattern(forEach_.getName(), condition, true,
                                childNodes, topScope);

                // link forEach and assignI node
                topScope.linkedBrotherNodes(assignINode, forEachNode);
            }
            this.log.finest("end generate foreach");
        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        } catch (final BPELException e) {
            throw new CoreException(e);
        }
        return topScopeNode;
    }

    private Node generateScope(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope scopeDefinition,
            final BPELProcess bpelprocess) throws CoreException {
        try {
            Node scopeNode = null;
            scopeNode = CreationPatternFactory.getInstance()
                    .createScopePattern(scopeDefinition.getName(), scope);
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scopeComp = (com.ebmwebsourcing.easyviper.core.api.engine.Scope) scopeNode
                    .getComponent().getFcInterface("service");

            // affect variables in process
            this.affectVariablesInScope(bpelprocess, scopeDefinition, scopeComp);

            // register all partners
            for (final PartnerLink plt : scopeDefinition.getPartnerLinks()) {
                scope.getEndpoints().put(plt, new EndpointImpl());
            }

            // generate under activity in process
            if (scopeDefinition.getActivity() != null) {
                final Node initial = this.generateActivity(scopeComp,
                        scopeDefinition.getActivity(), bpelprocess);
                scopeComp.setInitialNode(initial);
            }

            // add all catchs in scope
            if (scopeDefinition.getFaultHandlers() != null) {
                this.generateFaultHandlers(scopeComp, scopeDefinition
                        .getFaultHandlers().getCatchs(), scopeDefinition
                        .getFaultHandlers().getCatchAll(), bpelprocess);
            }

            return scopeNode;
        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
    }

    private Node generateInvoke(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Invoke invoke, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate invoke");
        Node scopeNode = null;
        Node invokeNode = null;
        try {
            if (invoke == null) {
                throw new CoreException("Invoke cannot be null");
            }

            // create parent scope
            scopeNode = CreationPatternFactory.getInstance()
                    .createScopePattern("scopeOf_" + invoke.getName(), scope);

            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scopeComp = (com.ebmwebsourcing.easyviper.core.api.engine.Scope) scopeNode
                    .getComponent().getFcInterface("service");

            // create sender node
            final SenderBehaviour send = new SenderBehaviourImpl();
            send.setKind(SenderBehaviour.Kind.ASYNCHRONOUS);
            if (invoke.getOutputVariable() != null) {
                send.setKind(SenderBehaviour.Kind.SYNCHRONOUS);
            }

            send.setInputVariableName(new QName(invoke.getInputVariable()));
            if (invoke.getOutputVariable() != null) {
                send.setOutputVariableName(new QName(invoke.getOutputVariable()));
            }
            send.setFaultHandler(new BPELFaultHandler(bpelprocess, invoke));

            // find partner
            final PartnerLink partner = bpelprocess.getPartnerLink(invoke
                    .getPartnerLink());
            if (partner == null) {
                throw new CoreException(
                        "Impossible to find partner with name: "
                                + invoke.getPartnerLink());
            }

            // get Endpoint in process
            final Endpoint providerEndpoint = scope.findEndpoint(partner);

            // set soap adapter
            final SOAPAdapter soapAdapter = new SOAPAdapter(bpelprocess,
                    providerEndpoint, scope);
            if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                soapAdapter.setLog(this.log);
            }
            send.setMessageAdapter(soapAdapter);

            // find interface
            providerEndpoint.setInterfaceName(invoke.getInterface());
            if (providerEndpoint.getInterfaceName() == null) {

                final PartnerLinkType partnerLinkType = bpelprocess
                        .getImports().getPartnerLinkType(
                                partner.getPartnerLinkType());
                if (partnerLinkType == null) {
                    throw new CoreException(
                            "Impossible to find partner link type with name: "
                                    + partner.getPartnerLinkType());
                }
                final Role role = partnerLinkType.getRole(partner
                        .getPartnerRole());
                if (role == null) {
                    throw new CoreException(
                            "Impossible to find role with name: "
                                    + partner.getPartnerRole());
                }
                providerEndpoint.setInterfaceName(role.getInterfaceQName());
            }

            if (providerEndpoint.getInterfaceName() == null) {
                throw new CoreException(
                        "Impossible to find interface to invoke");
            }

            // find service and endpoint if exist
            final Interface itf = bpelprocess.getImports().findInterface(
                    providerEndpoint.getInterfaceName());
            if (itf == null) {
                throw new CoreException("Impossible to find this interface: "
                        + providerEndpoint.getInterfaceName());
            }
            final Description abstraiteDescription = bpelprocess.getImports()
                    .getDescriptionByInterface(itf.getQName());
            Description concreteDescription = null;
            final Collection<org.petalslink.abslayer.service.api.Endpoint> endpoints = bpelprocess
                    .getImports().findEndpointsImplementingInterface(itf);
            if (!endpoints.isEmpty()) {
                org.petalslink.abslayer.service.api.Endpoint firstPossibleEndpoint = endpoints.iterator().next(); 
                providerEndpoint.setEndpointName(firstPossibleEndpoint.getName());
                providerEndpoint.setServiceName(firstPossibleEndpoint.getService()
                        .getQName());
                concreteDescription = bpelprocess.getImports()
                        .getDescriptionByService(
                                firstPossibleEndpoint.getService().getQName());
            }

            // find corresponding description following service or interface
            if (concreteDescription != null) {
                providerEndpoint.setDescription(concreteDescription);
            } else {
                providerEndpoint.setDescription(abstraiteDescription);
            }

            // find operation
            send.setOperationName(invoke.getOperation());

            send.setProviderEndpointKey(partner);

            invokeNode = scopeComp.createNode(invoke.getName(), send);

            // register provider endpoint
            scope.getEndpoints().put(partner, providerEndpoint);

            // initiate correlations
            this.initiateCorrelations(scope, invoke.getCorrelations(),
                    invoke.getInputVariable(), bpelprocess);

            // add invoke node to scope node of invoke
            scopeComp.setInitialNode(invokeNode);

            // add all catchs in scope
            this.generateFaultHandlers(scopeComp, invoke.getCatchs(),
                    invoke.getCatchAll(), bpelprocess);
        } catch (final BPELException e) {
            throw new CoreException(e);
        } catch (final NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        this.log.finest("end generate invoke");
        return scopeNode;
    }

    private void generateFaultHandlers(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope parentScope,
            final List<Catch> catchs, final CatchAll cathAll,
            final BPELProcess bpelprocess) throws CoreException,
            NoSuchInterfaceException, BPELException {
        this.log.finest("start generate generateFaultHandlers");
        for (final Catch catch_ : catchs) {

            // create parent scope
            final Node catchScope = CreationPatternFactory.getInstance()
                    .createScopePattern(
                            "catchScopeOf_" + catch_.getFaultName(),
                            parentScope);
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope catchScopeComp = (com.ebmwebsourcing.easyviper.core.api.engine.Scope) catchScope
                    .getComponent().getFcInterface("service");

            final Fault fault = new FaultImpl();

            if (catch_.getFaultName() != null) {
                fault.setFaultName(catch_.getFaultName());
            } else {
                fault.setFaultName(new QName("unknown"));
            }
            BPELVariable faultVar = null;
            if (catch_.getFaultVariable() != null) {
                faultVar = (BPELVariable) parentScope.findVariable(new QName(
                        catch_.getFaultVariable()));
            }
            if (faultVar == null) {
                // create fault variable
                if (catch_.getFaultVariable() != null) {
                    final TVariable fvar = new TVariable();
                    fvar.setElement(catch_.getFaultElement());
                    fvar.setMessageType(catch_.getFaultMessageType());
                    fvar.setName(catch_.getFaultVariable());
                    faultVar = new BPELElementVariableImpl(fvar, null, catch_);

                    this.addVariableInScope(catchScopeComp, faultVar);
                }
            }
            fault.setVariable(faultVar);

            fault.setFaultHandler(new BPELFaultHandler(bpelprocess, null));
            parentScope.getExceptions().put(fault, catchScopeComp);

            final Node activityNode = this.generateActivity(catchScopeComp,
                    catch_.getActivity(), bpelprocess);
            catchScopeComp.setInitialNode(activityNode);

        }

        // add catch all
        if (cathAll != null) {

            // create parent scope
            final Node catchScope = CreationPatternFactory.getInstance()
                    .createScopePattern("catchScopeOf_" + "catchAll",
                            parentScope);
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope catchScopeComp = (com.ebmwebsourcing.easyviper.core.api.engine.Scope) catchScope
                    .getComponent().getFcInterface("service");

            final Fault fault = new FaultImpl();
            fault.setFaultName(new QName("unknown"));
            fault.setFaultHandler(new BPELFaultHandler(bpelprocess, null));
            parentScope.getExceptions().put(fault, catchScopeComp);

            final Node activityNode = this.generateActivity(catchScopeComp,
                    cathAll.getActivity(), bpelprocess);
            catchScopeComp.setInitialNode(activityNode);

        }
        this.log.finest("end generate generateFaultHandlers");
    }

    private void initiateCorrelations(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final List<Correlation> correlations, final String inputVariable,
            final BPELProcess bpelprocess) throws BPELException {
        try {
            if ((correlations != null) && (correlations.size() > 0)) {
                this.log.finest("number of correlations defined in this activity: "
                        + correlations.size());
                for (final Correlation correlation : correlations) {
                    if ((correlation.getInitiate().equals(TInitiate.YES))
                            || (correlation.getInitiate()
                                    .equals(TInitiate.JOIN))) {

                        if (scope.findCorrelationGroups(correlation.getSet())
                                .size() == 0) {

                            // find CorrelationSet
                            final CorrelationSet correlationSet = bpelprocess
                                    .getCorrelationSet(correlation.getSet());
                            if (correlationSet == null) {
                                throw new BPELException(
                                        "Impossible to find the correlation set corresponding to this name "
                                                + correlation.getSet());
                            }

                            // get variable
                            final Variable var = scope.findVariable(new QName(
                                    inputVariable));
                            final BPELVariable varDef = (BPELVariable) var;

                            if (var == null) {
                                throw new BPELException(
                                        "Impossible to find variable corresponding to this name "
                                                + inputVariable);
                            }

                            final CorrelationGroup correlationGroup = new CorrelationGroupImpl();
                            final Map<String, com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation> coreCorrelations = new HashMap<String, com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation>();
                            correlationGroup.setCorrelations(coreCorrelations);

                            // find corresponding properties
                            final List<QName> propertiesName = correlationSet
                                    .getProperties();
                            for (final QName propertyName : propertiesName) {

                                final Property prop = bpelprocess.getImports()
                                        .getProperty(propertyName);
                                if (prop == null) {
                                    throw new BPELException(
                                            "Impossible to find property corresponding to this name "
                                                    + propertyName);
                                }

                                // find corresponding propertiesAlias
                                final List<PropertyAlias> propertiesAliases = bpelprocess
                                        .getImports()
                                        .getPropertyAliases4ThisProperty(
                                                prop.getQName());

                                if (propertiesAliases != null) {

                                    for (final PropertyAlias propertyAlias : propertiesAliases) {

                                        // math correlation with variable
                                        boolean correlationMatching = false;
                                        if ((propertyAlias.getElement() != null)
                                                && (propertyAlias.getElement()
                                                        .equals(varDef
                                                                .getElement()))) {
                                            correlationMatching = true;
                                        } else if ((propertyAlias
                                                .getMessageType() != null)
                                                && (propertyAlias
                                                        .getMessageType()
                                                        .equals(varDef
                                                                .getMessageType()))) {
                                            correlationMatching = true;
                                        } else if ((propertyAlias.getType() != null)
                                                && (propertyAlias.getType()
                                                        .equals(varDef
                                                                .getTypeQName()))) {
                                            correlationMatching = true;
                                        }

                                        if (correlationMatching) {
                                            final To to = new ToImpl(new TTo(),
                                                    null);
                                            to.setKind(To.Kind.VARIABLE_PROPERTY);
                                            to.setVariableProperty(new VariablePropertyImpl(
                                                    inputVariable, prop
                                                            .getQName()));

                                            final From from = new FromImpl(
                                                    new TFrom(), null);
                                            from.setKind(From.Kind.VARIABLE_PROPERTY);

                                            final com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation corr = new com.ebmwebsourcing.easyviper.core.impl.soa.correlation.CorrelationImpl();
                                            corr.setName(correlation.getSet());
                                            corr.setOrignator(to);
                                            corr.setFollower(from);

                                            coreCorrelations.put(
                                                    corr.getName(), corr);
                                        }

                                    }
                                }
                            }

                            if (coreCorrelations.size() > 0) {
                                scope.getProcess().getCorrelationGroups()
                                        .add(correlationGroup);
                            }
                            this.log.finest("Correlation "
                                    + correlation.getSet()
                                    + " created and added to scope: "
                                    + scope.getProcess().getName());
                        } else {
                            this.log.finest("Correlation "
                                    + correlation.getSet() + " already created");
                        }

                    }

                }
            }
        } catch (final CoreException e) {
            throw new BPELException(e);
        }
    }

    private Node generateReply(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Reply reply, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate reply");
        Node replyNode = null;
        try {
            if (reply != null) {

                // create sender node
                final SenderBehaviour send = new SenderBehaviourImpl();
                send.setKind(SenderBehaviour.Kind.ASYNCHRONOUS);

                // find partner
                final PartnerLink partner = bpelprocess.getPartnerLink(reply
                        .getPartnerLink());
                if (partner == null) {
                    throw new CoreException(
                            "Impossible to find partner with name: "
                                    + reply.getPartnerLink());
                }
                
                send.setInputVariableName(new QName(reply.getOutputVariable()));
                // get Endpoint in process
                String plString = reply.getPartnerLink();

                PartnerLink partnerlink = bpelprocess.findPartnerLink(plString);
                final Endpoint myRoleEndpoint = scope.findEndpoint(partnerlink);
                
                Interface itf = null;
                if (reply.getInterface() != null) {
                    itf = bpelprocess.getImports().findInterface(
                            reply.getInterface());
                    if (itf == null) {
                        throw new CoreException(
                                "Impossible to find interface corresponding to "
                                        + reply.getInterface());
                    }
                } else {
                    // TODO jlesbegu Check and then create function to be use
                    // also in generateInvoke...
                    String pls = reply.getPartnerLink();
                    if (pls != null) {
                        PartnerLink pl = bpelprocess.getPartnerLink(pls);
                        if (pl != null) {
                            QName plt = pl.getPartnerLinkType();
                            PartnerLinkType pLT = bpelprocess.getImports()
                                    .getPartnerLinkType(plt);
                            Role r = pLT.getRole(pl.getMyRole());
                            itf = bpelprocess.getImports().findInterface(
                                    r.getInterfaceQName());
                        }
                    }
                }

                if(itf == null) throw new CoreException(
                                                                          "Impossible to find interface corresponding to "
                                                                          + reply.getInterface()+" ...");
                                                          
                                                          final Description abstraiteDescription = bpelprocess
                                                          .getImports().getDescriptionByInterface(itf.getQName());
                                                          Description concreteDescription = null;
                                                          final Collection<org.petalslink.abslayer.service.api.Endpoint> endpoints = bpelprocess
                                                          .getImports().findEndpointsImplementingInterface(itf);
                                                          if (!endpoints.isEmpty()) {
                                                              org.petalslink.abslayer.service.api.Endpoint firstPossibleEndpoint = 
                                                                  endpoints.iterator().next();
                                                                  myRoleEndpoint.setEndpointName(firstPossibleEndpoint.getName());
                                      myRoleEndpoint.setServiceName(firstPossibleEndpoint.getService()
                                                            .getQName());
                                            concreteDescription = bpelprocess.getImports()
                                            .getDescriptionByService(
                                                    firstPossibleEndpoint.getService().getQName());
    
                                    }
    
                                    if(reply.getInterface() != null){
                                            myRoleEndpoint.setInterfaceName(reply.getInterface());
                                    }
                                    if(reply.getOperation() != null){
                                            send.setOperationName(reply.getOperation());
                                            myRoleEndpoint.setInvokedOperation(reply.getOperation());
                                    }
    
                        
                        
                if (itf != null) {
                    myRoleEndpoint.setDescription(itf.getParentDescription());
                }
                send.setProviderEndpointKey(partner);

                // set soap adapter
                final SOAPAdapter soapAdapter = new SOAPAdapter(bpelprocess,
                        myRoleEndpoint, scope);
                if (!this.log.getName()
                        .equals(BPELCompilerImpl.class.getName())) {
                    soapAdapter.setLog(this.log);
                }
                send.setMessageAdapter(soapAdapter);

                replyNode = scope.createNode(reply.getName(), send);

                // initiate correlations
                this.initiateCorrelations(scope, reply.getCorrelations(),
                        reply.getOutputVariable(), bpelprocess);

            }
            this.log.finest("end generate reply");
        } catch (final BPELException e) {
            throw new CoreException(e);
        }
        return replyNode;
    }

    private Node generateReceive(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Receive receive, final BPELProcess bpelprocess)
            throws CoreException {
        Node receiveNode = null;
        this.log.finest("start generate receive");
        try {
            if (receive != null) {

                // initiate correlations
                this.initiateCorrelations(scope, receive.getCorrelations(),
                        receive.getInputVariable(), bpelprocess);

                // create receiver node
                final ReceiverBehaviour receiver = new ReceiverBehaviourImpl();
                receiver.addVariableName(new QName(receive.getInputVariable()));
                this.log.finest("create receiver behaviour");

             // find partner
                 final PartnerLink partner = bpelprocess.getPartnerLink(receive
                                 .getPartnerLink());
                 if (partner == null) {
                         throw new CoreException(
                                         "Impossible to find partner with name: "
                                         + receive.getPartnerLink());
                 }
                
                 receiver.setClientEndpointKey(partner);
                
                 // get Endpoint in process
                 final Endpoint clientEndpoint = scope.findEndpoint(partner);                            
                
                
                 // set soap adapter
                 final SOAPAdapter soapAdapter = new SOAPAdapter(bpelprocess,
                                 clientEndpoint, scope);
                
                 if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                         soapAdapter.setLog(this.log);
                 }
                
                 // find interface
                 clientEndpoint.setInterfaceName(receive.getInterface());
                 if (clientEndpoint.getInterfaceName() == null) {
                
                         final PartnerLinkType partnerLinkType = bpelprocess
                         .getImports().getPartnerLinkType(
                                         partner.getPartnerLinkType());
                         if (partnerLinkType == null) {
                                 throw new CoreException(
                                                 "Impossible to find partner link type with name: "
                                                 + partner.getPartnerLinkType());
                         }
                         final Role role = partnerLinkType.getRole(partner
                                         .getMyRole());
                         if (role == null) {
                                 throw new CoreException(
                                                 "Impossible to find role with name: "
                                                 + partner.getPartnerRole());
                         }
                         clientEndpoint.setInterfaceName(role.getInterfaceQName());
                 }
                
                 if (clientEndpoint.getInterfaceName() == null) {
                         throw new CoreException(
                         "Impossible to find interface to invoke");
                 }
                
                 // find service and endpoint if exist
                 final Interface itf = bpelprocess.getImports().findInterface(
                                 clientEndpoint.getInterfaceName());
                 if (itf == null) {
                         throw new CoreException("Impossible to find this interface: "
                                         + clientEndpoint.getInterfaceName());
                 }
                 final Description abstraiteDescription = bpelprocess
                 .getImports().getDescriptionByInterface(itf.getQName());
                 Description concreteDescription = null;
                 final Collection<org.petalslink.abslayer.service.api.Endpoint> endpoints = bpelprocess
                 .getImports().findEndpointsImplementingInterface(itf);
                 if ((endpoints != null) && (endpoints.size() > 0)) {
                     org.petalslink.abslayer.service.api.Endpoint firstPossibleEndpoint = endpoints.iterator().next();
                         clientEndpoint.setEndpointName(firstPossibleEndpoint.getName());
                         clientEndpoint.setServiceName(firstPossibleEndpoint.getService()
                                         .getQName());
                         concreteDescription = bpelprocess.getImports()
                         .getDescriptionByService(
                                 firstPossibleEndpoint.getService().getQName());
                 }
                
                 // find corresponding description following service or interface
                 if (concreteDescription != null) {
                         clientEndpoint.setDescription(concreteDescription);
                 } else {
                         clientEndpoint.setDescription(abstraiteDescription);
                 }
                 
                
                 scope.getEndpoints().put(partner, clientEndpoint);
                
                // set message matcher
                final MessageMatcher matcher = new BPELMessageMatcher(
                        bpelprocess.getImports());
                if (!this.log.getName()
                        .equals(BPELCompilerImpl.class.getName())) {
                    matcher.setLog(this.log);
                }
                receiver.setMessageMatcher(matcher);

                // set correlation matcher
                if (!receive.getCreateInstance()) {
                    List<Correlation> correlations = receive.getCorrelations();

                    if ((correlations == null) && (receive.getCreateInstance())) {
                        correlations = new ArrayList<Correlation>();
                    }
                    final BPELCorrelationMatcher correlationMatcher = new BPELCorrelationMatcher(
                            bpelprocess, correlations, new QName(
                                    receive.getInputVariable()));
                    if (!this.log.getName().equals(
                            BPELCompilerImpl.class.getName())) {
                        correlationMatcher.setLog(this.log);
                    }
                    final List<CorrelationMatcher> corrs = new ArrayList<CorrelationMatcher>();
                    corrs.add(correlationMatcher);
                    receiver.setCorrelationsMatchers(corrs);
                }

                receiveNode = scope.createNode(receive.getName(), receiver);
                this.log.finest("create receiver scope");

            }
        } catch (final BPELException e) {
            throw new CoreException(e);
        }
        this.log.finest("end generate receive");
        return receiveNode;
    }

    private Node generateAssign(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Assign assign, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate assign");
        Node assignNode = null;
        if (assign != null) {
            // create assign node
            final AssignBehaviour assignBehaviour = new AssignBehaviourImpl();

            for (final Copy copy : assign.getCopy()) {

                final BPELAssignementExpression assignExp = new BPELAssignementExpressionImpl(
                        copy, bpelprocess);
                if (!this.log.getName()
                        .equals(BPELCompilerImpl.class.getName())) {
                    assignExp.setLog(this.log);
                }
                assignBehaviour.addAssignementExpression(assignExp);
            }

            assignNode = scope.createNode(assign.getName(), assignBehaviour);

        }
        this.log.finest("end generate assign");
        return assignNode;
    }

    private Node generateEmpty(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Empty empty, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate empty");
        final Node emptyNode = scope.createNode(empty.getName(),
                new EmptyBehaviourImpl());
        return emptyNode;
    }

    private Node generateWait(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Wait wait, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate wait");
        final WaitBehaviour waitBehaviour = new WaitBehaviourImpl();

        if (wait.getUntil() != null) {
            waitBehaviour.setDate((DateExpression<?>) wait.getUntil()
                    .copypaste());
        }

        if (wait.getFor() != null) {
            waitBehaviour.setDuration((LongExpression<?>) wait.getFor()
                    .copypaste());
        }

        final Node waitNode = scope.createNode(wait.getName(), waitBehaviour);
        return waitNode;
    }

    private Node generateThrow(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Throw thrw, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate throw");
        final ThrowBehaviour throwBehaviour = new ThrowBehaviourImpl();
        try {

            if (thrw.getFaultName().getNamespaceURI()
                    .equals(Constants.BPEL_20_EXECUTABLE_NAMESPACE)) {
                // get built-in exception
                final BuiltInException builtinException = BuiltInException
                        .valueOfBPELBuiltInExceptionFrom(thrw.getFaultName()
                                .getLocalPart());
                if (builtinException == null) {
                    throw new CoreException(
                            "Impossible to find built in exception constant from this value: "
                                    + thrw.getFaultName());
                }

                final Class<? extends BPELException> bpelException = builtinException
                        .getClass();
                final Constructor<? extends BPELException> constructor = bpelException
                        .getConstructor();
                final BPELException builtInException = constructor
                        .newInstance();
                throwBehaviour.setException(builtInException);

            } else {
                BPELVariable variable = (BPELVariable) scope
                        .findVariable(new QName(thrw.getFaultVariable()));
                UserDefinedException userException = null;
                if (variable.getElement() != null) {
                    this.log.finest("Creating new UserDefinedException based on a variable element");
                    userException = new UserDefinedException(
                            thrw.getFaultName(), thrw.getFaultVariable(),
                            UserDefinedException.FaultQnameType.ELEMENT_QNAME,
                            variable.getElement(), scope);
                } else {
                    this.log.finest("Creating new UserDefinedException based on a variable message");
                    userException = new UserDefinedException(
                            thrw.getFaultName(), thrw.getFaultVariable(),
                            UserDefinedException.FaultQnameType.MESSAGE_QNAME,
                            variable.getMessageType(), scope);
                }
                throwBehaviour.setException(userException);
            }

        } catch (final SecurityException e) {
            throw new CoreException(e);
        } catch (final InstantiationException e) {
            throw new CoreException(e);
        } catch (final IllegalAccessException e) {
            throw new CoreException(e);
        } catch (final InvocationTargetException e) {
            throw new CoreException(e);
        } catch (final NoSuchMethodException e) {
            throw new CoreException(e);
        }

        final Node throwNode = scope.createNode(thrw.getName(), throwBehaviour);
        return throwNode;
    }

    private Node generateExit(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Exit exit, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate exit");
        final Node exitNode = scope.createNode(exit.getName(),
                new ExitBehaviourImpl());
        return exitNode;
    }

    private Node generateReThrow(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final ReThrow rethrow, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate rethrow");
        final ReThrowBehaviour reThrowBehaviour = new ReThrowBehaviourImpl();
        final Node rethrowNode = scope.createNode(rethrow.getName(),
                reThrowBehaviour);
        this.log.finest("end generate rethrow");
        return rethrowNode;
    }

    private Node generateActivity(
            final com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            final Activity activity, final BPELProcess bpelprocess)
            throws CoreException {
        this.log.finest("start generate activty: " + activity);
        Node activityNode = null;
        if (activity != null) {
            if (activity instanceof Empty) {
                activityNode = this.generateEmpty(scope, (Empty) activity,
                        bpelprocess);
            } else if (activity instanceof Wait) {
                activityNode = this.generateWait(scope, (Wait) activity,
                        bpelprocess);
            } else if (activity instanceof Sequence) {
                activityNode = this.generateSequence(scope,
                        (Sequence) activity, bpelprocess);
            } else if (activity instanceof Flow) {
                activityNode = this.generateFlow(scope, (Flow) activity,
                        bpelprocess);
            } else if (activity instanceof If) {
                activityNode = this.generateIf(scope, (If) activity,
                        bpelprocess);
            } else if (activity instanceof While) {
                activityNode = this.generateWhile(scope, (While) activity,
                        bpelprocess);
            } else if (activity instanceof RepeatUntil) {
                activityNode = this.generateRepeatUntil(scope,
                        (RepeatUntil) activity, bpelprocess);
            } else if (activity instanceof ForEach) {
                activityNode = this.generateForEach(scope, (ForEach) activity,
                        bpelprocess);
            } else if (activity instanceof Invoke) {
                activityNode = this.generateInvoke(scope, (Invoke) activity,
                        bpelprocess);
            } else if (activity instanceof Receive) {
                activityNode = this.generateReceive(scope, (Receive) activity,
                        bpelprocess);
            } else if (activity instanceof Reply) {
                activityNode = this.generateReply(scope, (Reply) activity,
                        bpelprocess);
            } else if (activity instanceof Assign) {
                activityNode = this.generateAssign(scope, (Assign) activity,
                        bpelprocess);
            } else if (activity instanceof Pick) {
                activityNode = this.generatePick(scope, (Pick) activity,
                        bpelprocess);
            } else if (activity instanceof com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope) {
                activityNode = this
                        .generateScope(
                                scope,
                                (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope) activity,
                                bpelprocess);
            } else if (activity instanceof Throw) {
                activityNode = this.generateThrow(scope, (Throw) activity,
                        bpelprocess);
            } else if (activity instanceof ReThrow) {
                activityNode = this.generateReThrow(scope, (ReThrow) activity,
                        bpelprocess);
            } else if (activity instanceof Exit) {
                activityNode = this.generateExit(scope, (Exit) activity,
                        bpelprocess);
            } else if (activity instanceof ExtensionActivity) {
                activityNode = this.generateExtendedActivity(scope,
                        ((ExtensionActivity) activity).getExtendedActivity(),
                        bpelprocess);
            } else {
                // TODO: realized all activities
                throw new CoreException("unknown activity: " + activity);
            }
        }
        this.log.finest("end generate activity");
        return activityNode;
    }

    private Node generateExtendedActivity(
            com.ebmwebsourcing.easyviper.core.api.engine.Scope scope,
            ExtendedActivity activity, BPELProcess bpelprocess)
            throws CoreException {
        Node node = null;
        if (activity != null) {
            node = activity.generate(scope);
        } else {
            // activity unrecognized but that can be ignored
            node = scope.createNode(null, new EmptyBehaviourImpl());
        }
        return node;
    }

    public void setLog(final Logger logger) {
        this.log = logger;
    }

}
