package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnAlarm;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.OnAlarmValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnAlarmPick;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class OnAlarmValidatorImpl implements OnAlarmValidator {

	private static Logger log = Logger.getLogger(OnMessageValidatorImpl.class.getName());

	private OnAlarm alarm = null;
	private TOnAlarmPick model = null;

	public OnAlarmValidatorImpl(final OnAlarm onAlarm) {
		this.alarm = onAlarm;
		this.model = (TOnAlarmPick) ((BPELElementImpl<?>)onAlarm).getModel();
	}

	public void validate() {
		// validation
		log.finest("validate onAlarm");
		
		if(model.getFor()==null && model.getUntil()==null) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(alarm, new BPELException("In OnAlarm => A OnAlarm must define either a date or a duration as a termination condition (None of these is defined in this OnAlarm).")));
		}
		
		if(model.getFor()!=null && model.getUntil()!=null) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(alarm, new BPELException("In OnAlarm => A OnAlarm must define either a date or a duration as a termination condition (both are defined in this Onalarm).")));
		}
	}

}
