/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.runtime;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.abslayer.service.api.Binding.BindingStyle;

import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELMessageMatcher implements MessageMatcher {

    private Logger log = Logger.getLogger(BPELMessageMatcher.class.getName());

    private final Descriptions desc;

    public BPELMessageMatcher(final Descriptions desc) {
        this.desc = desc;
    }

    public boolean match(final Variable var, final InternalMessage<?> message)
    throws CoreException {
        boolean res = false;
        if (!(var instanceof BPELVariableImpl)) {
            throw new CoreException(
            "Error: this variable does not correspond to BPEL model");
        }

        final BPELVariableImpl bpelVariable = (BPELVariableImpl) var;

        BindingOperation bindingOperation = null;
        // get the interface
        final Service service = this.desc.findService(message
                .getService());
        final Endpoint endpoint = service.getEndpoint(message
                .getEndpoint());
        final Interface itf = endpoint.getBinding().getInterface();
        Operation op = itf.getOperation(new QName(itf.getQName()
                .getNamespaceURI(), message.getOperationName()));
        if (op == null) {
            op = itf.getOperation(new QName(itf.getQName()
                    .getNamespaceURI(), message.getOperationName()));
            throw new CoreException("Impossible to find "
                    + message.getOperationName()
                    + " in wsdl descriptions");
        }

        Binding binding = endpoint.getBinding();
        if (op != null) {
            // find the binding operation
            if (binding == null) {
                throw new CoreException(
                        "Impossible to find binding corresponding to interface: "
                        + itf.getQName());
            }



            if (message.getQName() == null) {
                if ((message.getOperationName() != null)
                        && (message.getService() != null)
                        && (message.getEndpoint() != null)) {

                    bindingOperation = binding.getOperationByName(op.getName());

                    if (bindingOperation != null) {

                        // find the mode
                        if (bindingOperation.getStyle() == BindingStyle.DOCUMENT) {
                            this.log.finest("find qname message for document");

                            if(op.getInput() != null) {
                                message.setQName(op.getInput().getMessageName());
                            }
                        } else if (bindingOperation.getStyle() == BindingStyle.RPC) {
                            this.log.finest("find qname message for rpc");
                            message.setQName(new QName(binding.getInterface().getParentDescription().getTargetNamespace(), op.getName()));
                        }
                    }

                    this.log.finest("Message name setted: "
                            + message.getQName());
                    // TODO to here

                } else {
                    throw new CoreException("The message has no service/endpoint/operation defined.");
                }
            }
        }

        if ((message != null) && (message.getQName() != null)) {
            // match name
            boolean checkName = false;
            //           System.out.println("message.getQName() = " + message.getQName());
            //           System.out.println("bpelVariable.getMessageType() = " + bpelVariable.getMessageType());
            //           System.out.println("bpelVariable.getElement() = " + bpelVariable.getElement());


            if ((bpelVariable.getMessageType() != null)
                    && (bpelVariable.getMessageType().equals(message.getQName()))) {
                checkName = true;
            }

            if(!checkName){
                Message msg = this.desc.findMessage(message.getQName());
                if(bindingOperation == null) {
                    bindingOperation = binding.getOperationByName(op.getName());
                }

                if (bindingOperation.getStyle() == BindingStyle.DOCUMENT) {

                    com.ebmwebsourcing.easyschema10.api.element.Element elmt = msg.getParts()[0].getElement();
                    System.out.println("elmt :"+elmt);
                    if(elmt != null){
                        if ((bpelVariable.getElement() != null) && (bpelVariable.getElement()
                                .equals(elmt.inferQName()))) {
                            checkName = true;
                        }
                    }

                }else if (bindingOperation.getStyle() == BindingStyle.RPC) {
                    if(message.getQName().getLocalPart().equals(op.getName())) {

                        if((bpelVariable.getMessageType() != null) && op.getInput().getMessageName().equals(bpelVariable.getMessageType())){
                            checkName = true;
                        }else if((bpelVariable.getElement() != null) && message.getQName().equals(bpelVariable.getElement())){
                            checkName = true;
                        }

                    }
                }
            }

            //TODO Delete this message matching and run unit test
            if ((!checkName)
                    && ((bpelVariable.getQName().getLocalPart() != null) && (bpelVariable
                            .getQName().getLocalPart().equals(message
                                    .getQName().getLocalPart())))) {
                checkName = true;
            }

            if (checkName) {
                this.log.finest("check on name of message: "
                        + message.getQName() + " is ok for variable "
                        + var.getQName());
                res = true;
            } else {
                this.log.finest("Error: check on name of message: "
                        + message.getQName() + " is not ok for variable "
                        + var.getQName());
            }

        } else {
            this.log.finest("the name of message is null: impossible to check for variable "
                    + var);
        }
        return res;
    }


    public void setLog(final Logger logger) {
        this.log = logger;
    }

}
