/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.PickValidator;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class PickValidatorImpl extends ActivityValidatorImpl<Pick> implements PickValidator {

	private static Logger log = Logger.getLogger(PickValidatorImpl.class.getName());


	public PickValidatorImpl(final Pick pick) {
		super(pick);
	}

	@Override
	public void validate() {
		super.validate();

		// validation
		log.finest("validate pick: " + this.getActivity().getName());

		TPick model = (TPick)((BPELElementImpl<?>)this.getActivity()).getModel();
		
		if( (model.getOnMessage()==null || model.getOnMessage().isEmpty())
				&&  (model.getOnAlarm()==null || model.getOnAlarm().isEmpty()) ) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("A Pick activity should have at least one OnMessage or one OnAlarm.")));
		}
		
		// unsupported element
		if(model.getCreateInstance().equals(TBoolean.YES)) {
			//BPELStaticAnalysisImpl.getInstance().addInfo(new BPELInfoImpl(this.getActivity(), "In receive " + this.getActivity().getName() + " => [BPEL engine restriction] Sorry, but the attribute createInstance to yes is currently ignored. The process is created on the first activity detected in the definition"));
			if(model.getOnAlarm()!=null && !model.getOnAlarm().isEmpty()) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.getActivity(), new BPELException("A Pick Activity having its \"createInstance\" attribute set to \"yes\" should not have onAlarm children.")));
			}
		}
	}

}
