/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.fault;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCatch;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class CatchImpl extends BPELElementImpl<TCatch> implements Catch {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	private Activity activity = null;

	public CatchImpl(final TCatch model, final BPELElement parent) {
		super(Constants._Catch_QNAME, model, parent);

		// get activity
		try {
			this.activity =  ActivityImpl.analyzeActivityContainer(this.model, this);
		} catch (final BPELException e) {
			if(this.getFaultName() != null) {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In catch " + this.getFaultName() + " => " + e.getMessage(), e)));
			} else {
				BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this, new BPELException("In one catch => " + e.getMessage(), e)));
			}
		} 
	}

	public QName getFaultName() {
		return this.model.getFaultName();
	}

	public QName getFaultMessageType() {
		return this.model.getFaultMessageType();
	}

	public QName getFaultElement() {
		return this.model.getFaultElement();
	}

	public String getFaultVariable() {
		return this.model.getFaultVariable();
	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

	public Activity getActivity() {
		return this.activity;
	}

}
