/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.inout;

import java.io.StringWriter;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang.NotImplementedException;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELWriterImpl implements com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELWriter {




	/*
	 * Private object initializations
	 */
	public BPELWriterImpl() throws BPELException {
		BPELJAXBContext.getInstance();
	}

	public JAXBContext getJaxbContext() throws BPELException {
		return BPELJAXBContext.getInstance().getJaxbContext();
	}

	/**
	 * Build the XML nodes from the WSDL descriptor in Java classes form.
	 *
	 * @param EndpointReferenceDescriptorClass
	 *            The EndpointReference Descriptor root class
	 * @param EndpointReferenceDescriptorNode
	 *            The XML Node to fill with the EndpointReference descriptor XML
	 *            nodes
	 */
	@SuppressWarnings("unchecked")
	public Document convertProcess2DOMElement(final TProcess bpelDescriptor)
	throws BPELException {
		Document doc = null;
		try {
			doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

			// TODO : Check if it is a Thread safe method
			final JAXBElement element = new JAXBElement(new QName(Constants.BPEL_20_EXECUTABLE_NAMESPACE,
					Constants.PROCESS_ROOT_TAG), bpelDescriptor.getClass(), bpelDescriptor);

			this.getJaxbContext().createMarshaller().marshal(element, doc);

		} catch (final JAXBException ex) {
			throw new BPELException(
					"Failed to build XML binding from WSDL descriptor Java classes", ex);
		} catch (final ParserConfigurationException ex) {
			throw new BPELException(
					"Failed to build XML binding from WSDL descriptor Java classes", ex);

		}
		return doc;
	}

	/**
	 * Build the XML String from the WSDL descriptor in Java classes form.
	 *
	 * @param WSDLDescriptorClass
	 *            The WSDL Descriptor root class
	 * @return The String to fill with the WSDL descriptor XML
	 * @throws BPELException
	 *             The exception raised during the marshaller creation or the
	 *             exception raised during the build of the XML string.
	 */
	@SuppressWarnings("unchecked")
	private String convertProcess2String(final TProcess processDescriptor)
	throws BPELException {

		try {
			final StringWriter stringWriter = new StringWriter();
			// TODO : Check if it is a Thread safe method

			final JAXBElement element = new JAXBElement(new QName(Constants.BPEL_20_EXECUTABLE_NAMESPACE,
					Constants.PROCESS_ROOT_TAG), processDescriptor.getClass(), processDescriptor);

			this.getJaxbContext().createMarshaller().marshal(element, stringWriter);

			return stringWriter.toString();
		} catch (final JAXBException e) {
			throw new BPELException(
					"Failed to build XML binding from Agreement descriptor Java classes", e);
		}
	}

	@SuppressWarnings("unchecked")
	public String getDefinition(final BPELElement element) throws BPELException {
		String res = null;
		try {
			final Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
			final JAXBElement jaxbElement = new JAXBElement(new QName(Constants.BPEL_20_EXECUTABLE_NAMESPACE,
					Constants.PROCESS_ROOT_TAG), ((BPELElementImpl)element).getModel().getClass(), ((BPELElementImpl)element).getModel());

			this.getJaxbContext().createMarshaller().marshal(jaxbElement, doc);

			res = XMLPrettyPrinter.prettyPrint(doc);
		} catch (final JAXBException e) {
			throw new BPELException(e);
		} catch (final ParserConfigurationException e) {
			throw new BPELException(e);
		}

		return res;
	}



	public Document getDocument(final BPELProcess processDef) throws BPELException {
		Document doc = null;
		if ((processDef != null)
				&& (processDef instanceof com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl)) {
			try {
				doc = this
				.convertProcess2DOMElement(((com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl) processDef)
						.getModel());
				if(processDef.getDocumentBaseURI() != null){
					doc.setDocumentURI(processDef.getDocumentBaseURI().getPath());
				}else{
					//TODO set a great URI for processDef created from scratch
					doc.setDocumentURI("virtualURI");
				}
			} catch (final BPELException e) {
				throw new BPELException("Can not write wsdl description", e);
			}
		}
		return doc;
	}

	public boolean getFeature(final String name) throws IllegalArgumentException {
		throw new NotImplementedException();
	}

	public void setFeature(final String name, final boolean value) throws IllegalArgumentException {
		throw new NotImplementedException();
	}

	public String writeBPEL(final BPELProcess processDef) throws BPELException {
		String res = null;
		if ((processDef != null)
				&& (processDef instanceof com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl)) {
			try {
				res = this
				.convertProcess2String(((com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl) processDef)
						.getModel());
			} catch (final BPELException e) {
				throw new BPELException("Can not write wsdl description", e);
			}
		}
		return res;
	}

}
