/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.test;

import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTAndExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTBooleanLiteral;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTCaracter;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTChildNodeXpathFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTCodepointsToStringFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTCompareFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTContainsFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTCountFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTCurrentDateFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTCurrentDateTimeFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTCurrentTimeFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTDateTimeFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTDayFromDateFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTDayFromDateTimeFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTDoXslTransform;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTEqualityExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTEscapeHTMLURIFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTInequalityExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTLowerCaseFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTNormalizeSpaceFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTNotFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStartWithFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTString;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStringLengthFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTSubstringAfterFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTSubstringBeforeFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTSubstringFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTUpperCaseFunction;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTVariable;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTXpathExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ParseException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

public class ExpressionTest
extends TestCase {
    public ExpressionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testExpression() throws ParseException, XPathExpressionException {
        ArrayList<String> expressions = new ArrayList<String>();
        expressions.add("fn:escape-html-uri(\"http://example.com/test#car\")");
        expressions.add("fn:escape-html-uri(\"http://example.com/~b\u00e9b\u00e9\")");
        expressions.add("fn:compare(\"tutu\", \"toto\")");
        expressions.add("fn:start-with(\"tutu\", \"tu\")");
        expressions.add("fn:contains(\"tutu\", \"tut\")");
        expressions.add("fn:codepoints-to-string(84, 104, 233, 114, 232, 115, 101)");
        expressions.add("fn:substring(\"Beatles\", 1, 4)");
        expressions.add("fn:substring(\"Beatles\", 2)");
        expressions.add("fn:substring-after(\"[commentaire1]{element1}toto\", \"{element1}\")");
        expressions.add("fn:substring-after(\"[commentaire1]{element1}toto\", \"}\")");
        expressions.add("fn:substring-after(\"tatetitotu\", \"ti\")");
        expressions.add("fn:substring-before(\"[commentaire1]{element1}toto\", \"{element1}\")");
        expressions.add("fn:substring-before(\"[commentaire1]{element1}toto\", \"}\")");
        expressions.add("fn:substring-before(\"tatetitotu\", \"ti\")");
        expressions.add("fn:string-length(\"Beatles\")");
        expressions.add("fn:normalize-space(\"The   XML\")");
        expressions.add("fn:upper-case(\"The   XML is great !\")");
        expressions.add("fn:lower-case(\"The   XML is great !\")");
        expressions.add("($a.titi/kiki + $b) = true()");
        expressions.add("($a.titi/kiki + $b) = doXslTransform(\"\",84, 104, 233, 114, 232, 115, 101)");
        expressions.add("$input.inputParam/tns:assure");
        expressions.add("doXslTransform(\"countAssureDTO.xsl\", $identGrcCriteresResponse.parameters)");
        expressions.add("test:doXslTransform(\"countAssureDTO.xsl\", $identGrcCriteresResponse.parameters)");
        expressions.add("$nbAssure > 0");
        expressions.add("$input.nir/tns:nir");
        expressions.add("$airLineResponse.parameters/ns0:booked=true() and $clientResponse.hotelConfirmationRequest/tns:validated=true()");
        expressions.add("$input.inputParam/tns:assure[4]");
        expressions.add("fn:current-date()");
        expressions.add("fn:current-dateTime()");
        expressions.add("fn:current-time()");
        expressions.add("fn:dateTime(fn:current-date(), fn:current-time())");
        expressions.add("fn:day-from-date(fn:current-date())");
        expressions.add("fn:day-from-dateTime()");
        expressions.add("true");
        expressions.add("$bidsArray/tns:ReceivedBid[$receivedBidNumber]");
        expressions.add("$bidsArray/tns:ReceivedBid/@BidId");
        expressions.add("$bidsArray/tns:ReceivedBid[$receivedBidNumber]/@BidId");
        expressions.add("$clientResponse.parameters/@firstName");
        expressions.add("'1'");
        expressions.add("$GetContactListOut.parameters/contactList[ child::node()[text()=$GetForkingProfileIn.parameters/callerSipURI] ]");
        expressions.add("child::node()[text()=$GetForkingProfileIn.parameters/callerSipURI]");
        expressions.add("text()=$GetForkingProfileIn.parameters/callerSipURI");
        expressions.add("$GetRulesOut.parameters/rule[$index]/conditions/calendarCondition/timeRangeCCondition/startTimeRangeCCondition");
        expressions.add("$GetRulesOut.parameters/rule[$index]");
        expressions.add("count($GetRulesOut.parameters/rule)");
        expressions.add("count($GetRulesOut.parameters/rule[$index])");
        expressions.add("count($GetRulesOut.parameters/rule[$index]/conditions)");
        expressions.add("$matched and count($GetRulesOut.parameters/rule[$index]/conditions/addressBookCondition/allABCondition)>0");
        expressions.add("not( $GetContactListOut.parameters/contactList[ child::node()[text()=$GetForkingProfileIn.parameters/callerSipURI] ] )");
        expressions.add("$matched and count($GetRulesOut.parameters/rule[$index]/conditions/calendarCondition/timeRangeCCondition/startTimeRangeCCondition)>0]]");
        expressions.add("number($timestampTime) &lt; number($GetRulesOut.parameters/rule[$index]/conditions/calendarCondition/timeRangeCCondition/startTimeRangeCCondition)");
        expressions.add("number($timestampTime) &gt; number($GetRulesOut.parameters/rule[$index]/conditions/calendarCondition/timeRangeCCondition/endTimeRangeCCondition)");
        expressions.add("not($GetRulesOut.parameters/rule[$index]/conditions/presenceCondition/presence = $GetPresenceOut.parameters/presi:getPresenceReturn/pres:state)");
        expressions.add("$cnavResponse.parameters/return/codeRetour=\"1\" and $msaResponse.parameters/return/codeRetour=\"1\" and $probtpResponse.parameters/return/codeRetour=\"1\"");
        expressions.add("$clientResponse.parameters/@type");
        expressions.add("''");
        expressions.add("\"test\nsur\nplusieurs\nligne\"");
        NamespaceMapperImpl ns = new NamespaceMapperImpl();
        ns.addNamespace("fn", "http://www.w3.org/2005/xpath-functions");
        boolean find = false;
        for (String expression : expressions) {
            find = false;
            System.out.println("----------------------------------------------");
            System.out.println("Expression to analyze: " + expression);
            ExpressionAnalyzer analyzer = new ExpressionAnalyzer(expression);
            ASTStart n = analyzer.Start();
            ExpressionDumpVisitor v = new ExpressionDumpVisitor(null, null, ns);
            n.jjtAccept((ExpressionVisitor)v, null);
            if (n.jjtGetChild(0) instanceof ASTEqualityExpression) {
                System.out.println("***************** Boolean expression find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTVariable) {
                System.out.println("***************** Identifier find + " + ((ASTVariable)n.jjtGetChild(0)).getImage());
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTDoXslTransform) {
                System.out.println("***************** DoXslTransform method find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTInequalityExpression) {
                System.out.println("***************** Inequality expression method find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTAndExpression) {
                System.out.println("***************** And expression method find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTCurrentDateFunction) {
                System.out.println("***************** current-date Function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTCurrentDateTimeFunction) {
                System.out.println("***************** current-dateTime Function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTCurrentTimeFunction) {
                System.out.println("***************** current-time Function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTDateTimeFunction) {
                System.out.println("***************** dateTime Function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTDayFromDateFunction) {
                System.out.println("***************** day-from-date Function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTDayFromDateTimeFunction) {
                System.out.println("***************** day-from-dateTime Function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTBooleanLiteral) {
                System.out.println("***************** boolean literal find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTCaracter) {
                System.out.println("***************** Caracter find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTChildNodeXpathFunction) {
                System.out.println("***************** child::node xpath function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTXpathExpression) {
                System.out.println("***************** xpath expression find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTCountFunction) {
                System.out.println("***************** count function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTNotFunction) {
                System.out.println("***************** not function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTCompareFunction) {
                System.out.println("***************** compare function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTContainsFunction) {
                System.out.println("***************** contains function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTCodepointsToStringFunction) {
                System.out.println("***************** codepoints-to-string function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTSubstringFunction) {
                System.out.println("***************** substring function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTStringLengthFunction) {
                System.out.println("***************** string-length function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTNormalizeSpaceFunction) {
                System.out.println("***************** normalize-space function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTLowerCaseFunction) {
                System.out.println("***************** lower-case function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTUpperCaseFunction) {
                System.out.println("***************** upper-case function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTEscapeHTMLURIFunction) {
                System.out.println("***************** escape-html-uri function find");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTSubstringAfterFunction) {
                System.out.println("***************** substring-after function found");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTSubstringBeforeFunction) {
                System.out.println("***************** substring-before function found");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTString) {
                System.out.println("***************** string found");
                find = true;
            } else if (n.jjtGetChild(0) instanceof ASTStartWithFunction) {
                System.out.println("***************** start-with found");
                find = true;
            }
            System.out.println("----------------------------------------------");
            if (find) continue;
            ExpressionTest.fail((String)("Expression failed: " + expression + " => " + n.jjtGetChild(0).getClass()));
        }
    }
}

