/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Documentation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExtensionElements;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TBaseElement;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTBaseElement;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDocumentation;

abstract class AbstractTBaseElementImpl<Model extends EJaxbTBaseElement>
extends AbstractJaxbXmlObjectImpl<Model> implements TBaseElement{

	protected AbstractTBaseElementImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
	@Override
	public Documentation[] getDocumentations() {
		return createChildrenArray(getModelObject().getDocumentation(), EJaxbTDocumentation.class, ANY_QNAME, DocumentationImpl.class);
	}
	
	@Override
	public boolean hasDocumentation(){
		return getModelObject().isSetDocumentation();
	}
	
	@Override
	public void addDocumentation(Documentation doc){
		addToChildren(getModelObject().getDocumentation(), doc);
	}
	
	@Override
	public void removeDocumentation(Documentation doc){
		removeFromChildren(getModelObject().getDocumentation(), doc);
	}
	
	@Override
	public ExtensionElements getExtensionElements() {
		if(this.getModelObject().getExtensionElements()==null){
			return null;
		}
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getExtensionElements(),
						ExtensionElementsImpl.class);
	}

	@Override
	public void setExtensionElements(ExtensionElements value) {
		if(value!=null){
			this.getModelObject().setExtensionElements(((ExtensionElementsImpl) value).getModelObject());
		}
		else{
			this.getModelObject().setExtensionElements(null);
		}
	}

	@Override
	public boolean hasExtensionElements() {
		return this.getModelObject().isSetExtensionElements();
	}

	@Override
	public String getId() {
		return this.getModelObject().getId();
	}

	@Override
	public void setId(String value) {
		this.getModelObject().setId(value);

	}

	@Override
	public Map<QName, String> getOtherAttributes() {
		return this.getModelObject().getOtherAttributes();
	}
	
	@Override
	public void addOtherAttribute(QName arg0, String arg1) {
		this.getModelObject().getOtherAttributes().put(arg0, arg1);
	}

	@Override
	public void clearOtherAttributes() {
		this.getModelObject().getOtherAttributes().clear();
	}

	@Override
	public String getOtherAttribute(QName arg0) {
		return this.getModelObject().getOtherAttributes().get(arg0);
	}

	@Override
	public boolean hasOtherAttribute(QName arg0) {
		return this.getModelObject().getOtherAttributes().containsKey(arg0);
	}

	@Override
	public void removeOtherAttribute(QName arg0) {
		this.getModelObject().getOtherAttributes().remove(arg0);
	}


}
