/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CorrelationKey;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TChoreographyActivity;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TChoreographyLoopType;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTChoreographyActivity;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTChoreographyLoopType;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCorrelationKey;

abstract class AbstractTChoreographyActivityImpl<Model extends EJaxbTChoreographyActivity> 
extends AbstractTFlowNodeImpl<Model> implements TChoreographyActivity {

	protected AbstractTChoreographyActivityImpl(XmlContext xmlContext,
			Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
	@Override
	public QName[] getParticipantRef() {
		List<QName> l = this.getModelObject().getParticipantRef();
		return l.toArray(new QName[l.size()]);
	}

	@Override
	public boolean hasParticipantRef() {
		return this.getModelObject().isSetParticipantRef();
	}

	@Override
	public void unsetParticipantRef() {
		this.getModelObject().unsetParticipantRef();
	}
	
	@Override
	public void addParticipantRef(QName ref){
		this.getModelObject().getParticipantRef().add(ref);
	}
	
	@Override
	public void removeParticipantRef(QName ref){
		this.getModelObject().getParticipantRef().remove(ref);
	}

	@Override
	public CorrelationKey[] getCorrelationKey() {
		return createChildrenArray(getModelObject().getCorrelationKey(),
				EJaxbTCorrelationKey.class, ANY_QNAME, CorrelationKeyImpl.class);
	}

	@Override
	public boolean hasCorrelationKey() {
		return this.getModelObject().isSetCorrelationKey();
	}

	@Override
	public void unsetCorrelationKey() {
		this.getModelObject().unsetCorrelationKey();

	}

	@Override
	public QName getInitiatingParticipantRef() {
		return this.getModelObject().getInitiatingParticipantRef();
	}

	@Override
	public void setInitiatingParticipantRef(QName value) {
		this.getModelObject().setInitiatingParticipantRef(value);

	}

	@Override
	public boolean hasInitiatingParticipantRef() {
		return this.getModelObject().isSetInitiatingParticipantRef();
	}

	@Override
	public TChoreographyLoopType getLoopType() {
		if (getModelObject().getLoopType() == null){
			return null;
		}
		TChoreographyLoopType result = null;
		switch (getModelObject().getLoopType()) {
		case MULTI_INSTANCE_PARALLEL:
			result = TChoreographyLoopType.MultiInstanceParallel;
			break;
		case MULTI_INSTANCE_SEQUENTIAL:
			result = TChoreographyLoopType.MultiInstanceSequential;
			break;
		case NONE:
			result = TChoreographyLoopType.None;
			break;
		case STANDARD:
			result = TChoreographyLoopType.Standard;
			break;
		}
		return result;
	}

	@Override
	public void setLoopType(TChoreographyLoopType value) {
		if (value == null) {
			getModelObject().setLoopType(null);
		} else if (value.equals(TChoreographyLoopType.MultiInstanceParallel)) {
			getModelObject().setLoopType(
					EJaxbTChoreographyLoopType.MULTI_INSTANCE_PARALLEL);
		} else if (value.equals(TChoreographyLoopType.MultiInstanceSequential)) {
			getModelObject().setLoopType(
					EJaxbTChoreographyLoopType.MULTI_INSTANCE_SEQUENTIAL);
		} else if (value.equals(TChoreographyLoopType.None)) {
			getModelObject().setLoopType(EJaxbTChoreographyLoopType.NONE);
		} else if (value.equals(TChoreographyLoopType.Standard)) {
			getModelObject().setLoopType(EJaxbTChoreographyLoopType.STANDARD);
		}
	}

	@Override
	public boolean hasLoopType() {
		return this.getModelObject().isSetLoopType();
	}

}
