/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Auditing;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Monitoring;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TFlowElement;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFlowElement;

abstract class AbstractTFlowElementImpl<Model extends EJaxbTFlowElement>
extends AbstractTBaseElementImpl<Model> implements TFlowElement{

	protected AbstractTFlowElementImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public Auditing getAuditing() {
		if(this.getModelObject().getAuditing()==null){
			return null;
		}
		return this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getAuditing(), AuditingImpl.class);
	}

	@Override
	public void setAuditing(Auditing value) {
		if(value!=null){
			this.getModelObject().setAuditing(((AuditingImpl)value).getModelObject());
		}
		else{
			this.getModelObject().setAuditing(null);
		}
	}

	@Override
	public boolean hasAuditing() {
		return this.getModelObject().isSetAuditing();
	}

	@Override
	public Monitoring getMonitoring() {
		if(this.getModelObject().getMonitoring()==null){
			return null;
		}
		return this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getMonitoring(), MonitoringImpl.class);
	}

	@Override
	public void setMonitoring(Monitoring value) {
		if(value!=null){
			this.getModelObject().setMonitoring(((MonitoringImpl)value).getModelObject());
		}
		else{
			this.getModelObject().setMonitoring(null);
		}
	}

	@Override
	public boolean hasMonitoring() {
		return this.getModelObject().isSetMonitoring();
	}

	@Override
	public QName[] getCategoryValueRef() {
		List<QName> l = this.getModelObject().getCategoryValueRef();
		return l.toArray(new QName[l.size()]);
	}

	@Override
	public boolean hasCategoryValueRef() {
		return this.getModelObject().isSetCategoryValueRef();
	}

	@Override
	public void unsetCategoryValueRef() {
		this.getModelObject().unsetCategoryValueRef();
	}
	
	@Override
	public void addCategoryValueRef(QName qname){
		this.getModelObject().getCategoryValueRef().add(qname);
	}
	
	@Override
	public void removeCategoryValueRef(QName qname){
		this.getModelObject().getCategoryValueRef().remove(qname);
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);

	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

}
