/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/

package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TFlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithFlowElements;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFlowNode;

abstract class AbstractTFlowNodeImpl<Model extends EJaxbTFlowNode> extends
        AbstractTFlowElementImpl<Model> implements TFlowNode {

    protected AbstractTFlowNodeImpl(XmlContext xmlContext, Model jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public QName[] getIncoming() {
        List<QName> l = this.getModelObject().getIncoming();
        return l.toArray(new QName[l.size()]);
    }

    @Override
    public boolean hasIncoming() {
        return this.getModelObject().isSetIncoming();
    }

    @Override
    public void unsetIncoming() {
        this.getModelObject().unsetIncoming();
    }

    @Override
    public void removeIncoming(QName qname) {
        this.getModelObject().getIncoming().remove(qname);
    }

    @Override
    public void addIncoming(QName qname) {
        this.getModelObject().getIncoming().add(qname);
    }

    @Override
    public QName[] getOutgoing() {
        List<QName> l = this.getModelObject().getOutgoing();
        return l.toArray(new QName[l.size()]);
    }

    @Override
    public boolean hasOutgoing() {
        return this.getModelObject().isSetOutgoing();
    }

    @Override
    public void unsetOutgoing() {
        this.getModelObject().unsetOutgoing();
    }

    @Override
    public void removeOutgoing(QName qname) {
        this.getModelObject().getOutgoing().remove(qname);
    }

    @Override
    public void addOutgoing(QName qname) {
        this.getModelObject().getOutgoing().add(qname);
    }

    @Override
    public List<FlowNode> getOutgoingFlowNodes() {
        WithFlowElements wfe = DefinitionsHelper.getParentContainer(this);
        List<FlowNode> result = new ArrayList<FlowNode>();
        if(wfe.hasFlowElement()){
            for(SequenceFlow sf : wfe.getFlowElementsByClass(SequenceFlow.class)){
                if(sf.getSourceRef().equals(this)){
                    result.add(sf.getTargetRef());
                }
            }
        }
        return result;
    }

    @Override
    public List<FlowNode> getIncomingFlowNodes() {
        WithFlowElements wfe = DefinitionsHelper.getParentContainer(this);
        List<FlowNode> result = new ArrayList<FlowNode>();
        if(wfe.hasFlowElement()){
            for(SequenceFlow sf : wfe.getFlowElementsByClass(SequenceFlow.class)){
                if(sf.getTargetRef().equals(this)){
                    result.add(sf.getSourceRef());
                }
            }
        }
        return result;
    }

}
