/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Assignment;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TDataAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.ItemAwareElement;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTAssignment;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTBaseElement;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataAssociation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFormalExpression;

class TDataAssociationImpl extends
		AbstractTBaseElementImpl<EJaxbTDataAssociation> implements
		TDataAssociation {

	protected TDataAssociationImpl(XmlContext xmlContext,
			EJaxbTDataAssociation jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	public ItemAwareElement[] getSourceRef() {
		XmlObject[] t = createChildrenArray(getModelObject().getSourceRef(), EJaxbTBaseElement.class, ANY_QNAME);
		ItemAwareElement[] result = new ItemAwareElement[t.length];
		for(int i=0; i<t.length; i++){
			result[i] = (ItemAwareElement) t[i];
		}
		return result;
	}
	
	@Override
	public void addSourceRef(ItemAwareElement iae){
	    if(iae!=null){
	        addToChildren(getModelObject().getSourceRef(), (XmlObject)iae);
	    }
	}
	
	@Override
	public void removeSourceRef(ItemAwareElement iae){
	    if(iae!=null){
	        removeFromChildren(getModelObject().getSourceRef(), (XmlObject)iae);
	    }
	}

	@Override
	public boolean hasSourceRef() {
		return this.getModelObject().isSetSourceRef();
	}

	@Override
	public void unsetSourceRef() {
		this.getModelObject().unsetSourceRef();
	}

	@Override
	public ItemAwareElement getTargetRef() {
	    if(getModelObject().getTargetRef()==null){
	        return null;
	    }
		return (ItemAwareElement) getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getTargetRef());
	}

	@Override
	public void setTargetRef(ItemAwareElement value) {
	    if(value==null){
	        getModelObject().setTargetRef(null);
	    }
	    else{
	        this.getModelObject().setTargetRef(((AbstractXmlObjectImpl<?>)value).getModelObject());
	    }
	}

	@Override
	public boolean hasTargetRef() {
		return this.getModelObject().isSetTargetRef();
	}
	
	@Override
	public Expression getTransformation() {
		if(this.getModelObject().getTransformation()==null){
			return null;
		}
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getTransformation(),
						ExpressionImpl.class);
	}

	@Override
	public void setTransformation(Expression value) {
		if(value!=null){
			this.getModelObject().setTransformation((EJaxbTFormalExpression)((ExpressionImpl)value).getModelObject());
		}
		else{
			this.getModelObject().setTransformation(null);
		}
	}

	@Override
	public boolean hasTransformation() {
		return this.getModelObject().isSetTransformation();
	}

	@Override
	public Assignment[] getAssignment() {
		return createChildrenArray(getModelObject().getAssignment(),
				EJaxbTAssignment.class, ANY_QNAME, AssignmentImpl.class);
	}

	@Override
	public void addAssignment(Assignment a) {
		addToChildren(this.getModelObject().getAssignment(), a);
	}

	@Override
	public void removeAssignment(Assignment a) {
		removeFromChildren(this.getModelObject().getAssignment(), a);
	}
	
	@Override
	public boolean hasAssignment() {
		return this.getModelObject().isSetAssignment();
	}

	@Override
	public void unsetAssignment() {
		this.getModelObject().unsetAssignment();
	}

	@Override
	protected Class<? extends EJaxbTDataAssociation> getCompliantModelClass() {
		return EJaxbTDataAssociation.class;
	}

}
