/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataState;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TDataStoreReference;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataStoreReference;

class TDataStoreReferenceImpl extends
		AbstractTFlowElementImpl<EJaxbTDataStoreReference> implements
		TDataStoreReference {

	protected TDataStoreReferenceImpl(XmlContext xmlContext,
			EJaxbTDataStoreReference jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	public DataState getDataState() {
		if(this.getModelObject().getDataState()==null){
			return null;
		}
		return this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getDataState(), DataStateImpl.class);
	}

	@Override
	public void setDataState(DataState value) {
		if(value!=null){
			this.getModelObject().setDataState(((DataStateImpl)value).getModelObject());
		}
		else{
			this.getModelObject().setDataState(null);
		}
	}

	@Override
	public boolean hasDataState() {
		return this.getModelObject().isSetDataState();
	}

	@Override
	public QName getItemSubjectRef() {
		return this.getModelObject().getItemSubjectRef();
	}

	@Override
	public void setItemSubjectRef(QName value) {
		this.getModelObject().setItemSubjectRef(value);
	}

	@Override
	public boolean hasItemSubjectRef() {
		return this.getModelObject().isSetItemSubjectRef();
	}

	@Override
	public void setDataStoreRef(QName value) {
		this.getModelObject().setDataStoreRef(value);
	}

	@Override
	public boolean hasDataStoreRef() {
		return this.getModelObject().isSetDataStoreRef();
	}

	@Override
	protected Class<? extends EJaxbTDataStoreReference> getCompliantModelClass() {
		return EJaxbTDataStoreReference.class;
	}

	@Override
	public QName getDataStoreRef() {
		return this.getModelObject().getDataStoreRef();
	}

}
