/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Documentation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TExtension;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExtension;

class TExtensionImpl extends AbstractJaxbXmlObjectImpl<EJaxbTExtension>
		implements TExtension {

	protected TExtensionImpl(XmlContext xmlContext, EJaxbTExtension jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public QName getDefinition() {
		return null;
	}

	@Override
	public void setDefinition(QName value) {
		this.getModelObject().setDefinition(value);
	}

	@Override
	public boolean hasDefinition() {
		return this.getModelObject().isSetDefinition();
	}

	@Override
	public boolean isMustUnderstand() {
		return this.getModelObject().isMustUnderstand();
	}

	@Override
	public void setMustUnderstand(boolean value) {
		this.getModelObject().setMustUnderstand(value);
	}

	@Override
	public boolean hasMustUnderstand() {
		return this.getModelObject().isMustUnderstand();
	}

	@Override
	public void unsetMustUnderstand() {
		this.getModelObject().unsetMustUnderstand();
	}

	@Override
	protected Class<? extends EJaxbTExtension> getCompliantModelClass() {
		return EJaxbTExtension.class;
	}

	@Override
	public Documentation[] getDocumentation() {
		if (this.getModelObject().getDocumentation() != null) {
			return (Documentation[]) this.getModelObject().getDocumentation()
					.toArray();
		}
		return null;
	}

	@Override
	public boolean hasDocumentation() {
		return this.getModelObject().isSetDocumentation();
	}

	@Override
	public void unsetDocumentation() {
		this.getModelObject().unsetDocumentation();
	}

}
