/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TSequenceFlow;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExpression;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTSequenceFlow;

public class TSequenceFlowImpl extends
		AbstractTFlowElementImpl<EJaxbTSequenceFlow> implements TSequenceFlow {

	protected TSequenceFlowImpl(XmlContext xmlContext,
			EJaxbTSequenceFlow jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTSequenceFlow> getCompliantModelClass() {
		return EJaxbTSequenceFlow.class;
	}

	@Override
	public Expression getConditionExpression() {
		if(this.getModelObject().getConditionExpression()==null){
			return null;
		}
		return (Expression) this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getConditionExpression());
	}

	@Override
	public void setConditionExpression(Expression value) {
		if(value!=null){
			this.getModelObject().setConditionExpression((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
		}
		else{
			this.getModelObject().setConditionExpression(null);
		}
	}

	@Override
	public boolean hasConditionExpression() {
		return this.getModelObject().isSetConditionExpression();
	}

	@Override
	public FlowNode getSourceRef() {
		if(this.getModelObject().getSourceRef()==null){
			return null;
		}
		else{
			return (FlowNode) this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getSourceRef());
		}
	}

	@Override
	public void setSourceRef(FlowNode value) {
		if (value != null) {
			this.getModelObject().setSourceRef(((AbstractTFlowNodeImpl<?>)value).getModelObject());
		}
		else{
			this.getModelObject().setSourceRef(null);
		}
	}

	@Override
	public boolean hasSourceRef() {
		return this.getModelObject().isSetSourceRef();
	}

	@Override
	public FlowNode getTargetRef() {
		if(this.getModelObject().getTargetRef()==null){
			return null;
		}
		else{
			return (FlowNode) this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getTargetRef());
		}
	}

	@Override
	public void setTargetRef(FlowNode value) {
		if (value != null) {
			this.getModelObject().setTargetRef(((AbstractTFlowNodeImpl<?>)value).getModelObject());
		}
		else{
			this.getModelObject().setTargetRef(null);
		}
	}

	@Override
	public boolean hasTargetRef() {
		return this.getModelObject().isSetTargetRef();
	}

	@Override
	public boolean isIsImmediate() {
		if(hasIsImmediate()){
			return this.getModelObject().isIsImmediate();
		}
		else{
			return false;
		}
	}

	@Override
	public void setIsImmediate(boolean value) {
		this.getModelObject().setIsImmediate(value);
	}

	@Override
	public boolean hasIsImmediate() {
		return this.getModelObject().isSetIsImmediate();
	}

	@Override
	public void unsetIsImmediate() {
		this.getModelObject().unsetIsImmediate();

	}
}
