/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Text;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TText;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TTextAnnotation;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTTextAnnotation;

class TTextAnnotationImpl extends
		AbstractTArtifactImpl<EJaxbTTextAnnotation> implements
		TTextAnnotation {

	protected TTextAnnotationImpl(XmlContext xmlContext,
			EJaxbTTextAnnotation jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	public TText getText() {
		return this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getText(), TTextImpl.class);
	}

	@Override
	public void setText(Text value) {
		this.getModelObject().setText(((TTextImpl)value).getModelObject());
	}

	@Override
	public boolean hasText() {
		return this.getModelObject().isSetText();
	}

	@Override
	public String getTextFormat() {
		return this.getModelObject().getTextFormat();
	}

	@Override
	public void setTextFormat(String value) {
		if (value != null) {
			this.getModelObject().setTextFormat(value);
		}
	}

	@Override
	public boolean hasTextFormat() {
		return this.getModelObject().isSetText();
	}

	@Override
	protected Class<? extends EJaxbTTextAnnotation> getCompliantModelClass() {
		return EJaxbTTextAnnotation.class;
	}

}
