/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.stream;

import com.ebmwebsourcing.easycommons.stream.DumbExecutor;
import com.ebmwebsourcing.easycommons.thread.SimultaneousTaskExecutor;
import java.io.IOException;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class DumbExecutorTest {
    private static final String testString = "Hello!\nWorld!";
    private static final String testString2 = "Linux!\nRocks!";

    @Test
    public void testStdOutCapture() {
        this.testStreamCapture(testString, new StdOutCaptureTester());
    }

    @Test
    public void testStdErrCapture() {
        this.testStreamCapture(testString, new StdErrCaptureTester());
    }

    private void testStreamCapture(final String testString, final StreamCaptureTester streamCaptureTester) {
        DumbExecutor dumbExecutor = new DumbExecutor(){

            public void doRun() {
                streamCaptureTester.printToCapturedStream(testString);
            }
        };
        dumbExecutor.run();
        streamCaptureTester.setDumbExecutorUnderTest(dumbExecutor);
        Assert.assertEquals((Object)testString, (Object)streamCaptureTester.getCapturedOutput());
    }

    @Test
    public void testStdOutCaptureWithUTF16Encoding() {
        this.testStreamCaptureWithUTF16Encoding(new StdOutCaptureTester());
    }

    @Test
    public void testStdErrCaptureWithUTF16Encoding() {
        this.testStreamCaptureWithUTF16Encoding(new StdErrCaptureTester());
    }

    public void testStreamCaptureWithUTF16Encoding(final StreamCaptureTester streamCaptureTester) {
        final String testString = new String(new byte[]{0, 72, 0, 69, 0, 76, 0, 76, 0, 79}, Charset.forName("UTF-16"));
        DumbExecutor dumbExecutor = new DumbExecutor(){

            public void doRun() {
                streamCaptureTester.printToCapturedStream(testString);
            }
        };
        dumbExecutor.run();
        streamCaptureTester.setDumbExecutorUnderTest(dumbExecutor);
        Assert.assertEquals((Object)"HELLO", (Object)streamCaptureTester.getCapturedOutput());
    }

    @Test
    public void testStdOutCaptureRollback() {
        this.testStreamCaptureRollback(new StdOutCaptureTester());
    }

    @Test
    public void testStdErrCaptureRollback() {
        this.testStreamCaptureRollback(new StdErrCaptureTester());
    }

    private void testStreamCaptureRollback(final StreamCaptureTester streamCaptureTester) {
        DumbExecutor dumbExecutor = new DumbExecutor(){

            public void doRun() {
                DumbExecutor dumbExecutor2 = new DumbExecutor(){

                    public void doRun() {
                        streamCaptureTester.printToCapturedStream(DumbExecutorTest.testString2);
                    }
                };
                streamCaptureTester.printToCapturedStream(DumbExecutorTest.testString);
                dumbExecutor2.run();
                streamCaptureTester.printToCapturedStream(DumbExecutorTest.testString);
            }
        };
        dumbExecutor.run();
        streamCaptureTester.setDumbExecutorUnderTest(dumbExecutor);
        Assert.assertEquals((Object)"Hello!\nWorld!Hello!\nWorld!", (Object)streamCaptureTester.getCapturedOutput());
    }

    @Test
    public void testThrowableCapture() {
        final IOException exception = new IOException("test exception");
        DumbExecutor dumbExecutor = new DumbExecutor(){

            public void doRun() throws Throwable {
                throw exception;
            }
        };
        dumbExecutor.run();
        Assert.assertEquals((Object)exception, (Object)dumbExecutor.getCapturedThrowable());
    }

    @Test
    public void testStdOutAndStdErrAndThrowableCapture() {
        String traceToOut = "trace to out.";
        String traceToErr = "trace to err.";
        final IOException exception = new IOException("test exception");
        DumbExecutor dumbExecutor = new DumbExecutor(){

            public void doRun() throws Throwable {
                System.out.print("trace to out.");
                System.err.print("trace to err.");
                throw exception;
            }
        };
        dumbExecutor.run();
        Assert.assertEquals((Object)exception, (Object)dumbExecutor.getCapturedThrowable());
        Assert.assertEquals((Object)"trace to out.", (Object)dumbExecutor.getCapturedStdOut());
        Assert.assertEquals((Object)"trace to err.", (Object)dumbExecutor.getCapturedStdErr());
    }

    @Test
    public void testSimultaneousStdOutCapture() throws Exception {
        this.testSimultaneousStreamCapture(new StdOutCaptureTester());
    }

    @Test
    public void testSimultaneousStdErrCapture() throws Exception {
        this.testSimultaneousStreamCapture(new StdErrCaptureTester());
    }

    public void testSimultaneousStreamCapture(final StreamCaptureTester streamCaptureTester) throws Exception {
        SimultaneousTaskExecutor simultaneousExecutor = new SimultaneousTaskExecutor();
        int nbThreads = 500;
        for (int i = 0; i < 500; ++i) {
            final String threadTestString = "Hello!\nWorld!-" + i;
            simultaneousExecutor.registerTask(new Runnable(){

                @Override
                public void run() {
                    DumbExecutorTest.this.testStreamCapture(threadTestString, streamCaptureTester);
                }
            });
            simultaneousExecutor.registerTask(new Runnable(){

                @Override
                public void run() {
                    streamCaptureTester.printToCapturedStream("This trace is not captured!\n");
                }
            });
        }
        simultaneousExecutor.executeAllRegisteredTasks();
    }

    private static class StdErrCaptureTester
    extends StreamCaptureTester {
        private StdErrCaptureTester() {
        }

        @Override
        final String getCapturedOutput() {
            return this.getDumbExecutorUnderTest().getCapturedStdErr();
        }

        @Override
        void printToCapturedStream(String str) {
            System.err.print(str);
        }
    }

    private static final class StdOutCaptureTester
    extends StreamCaptureTester {
        private StdOutCaptureTester() {
        }

        @Override
        String getCapturedOutput() {
            return this.getDumbExecutorUnderTest().getCapturedStdOut();
        }

        @Override
        void printToCapturedStream(String str) {
            System.out.print(str);
        }
    }

    private static abstract class StreamCaptureTester {
        private DumbExecutor dumbExecutorUnderTest = null;

        StreamCaptureTester() {
        }

        protected final DumbExecutor getDumbExecutorUnderTest() {
            assert (this.dumbExecutorUnderTest != null);
            return this.dumbExecutorUnderTest;
        }

        protected final void setDumbExecutorUnderTest(DumbExecutor dumbExecutorUnderTest) {
            this.dumbExecutorUnderTest = dumbExecutorUnderTest;
        }

        abstract String getCapturedOutput();

        abstract void printToCapturedStream(String var1);
    }
}

