/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.uuid;

import com.ebmwebsourcing.easycommons.uuid.QualifiedUUIDGenerator;
import com.ebmwebsourcing.easycommons.uuid.framework.orchestrator.GenUUIDFromMultipleQualifiedGeneratorOrchestrator;
import com.ebmwebsourcing.easycommons.uuid.framework.orchestrator.GenUUIDFromSingleQualifiedGeneratorOrchestrator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class QualifiedUUIDGeneratorTest
extends TestCase {
    private final int POOL_SIZE = 100;
    private final int ITERATIONS = 100;

    public void testGetNewID() {
        String domain = "foo";
        QualifiedUUIDGenerator generator = new QualifiedUUIDGenerator(domain);
        String uuid = generator.getNewID();
        String uuidPatern = "^" + domain + ":[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$";
        QualifiedUUIDGeneratorTest.assertTrue((String)"Generated uuid must match the followwing pattern 'domain:[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}'", (boolean)uuid.matches(uuidPatern));
    }

    public void testGetUuidMaxLength() {
        String domain = "foo";
        QualifiedUUIDGenerator generator = new QualifiedUUIDGenerator(domain);
        int uuidLength = generator.getUuidMaxLength();
        String uuid = generator.getNewID();
        QualifiedUUIDGeneratorTest.assertEquals((int)uuid.length(), (int)uuidLength);
    }

    public void testGenerateUniqueID() {
        try {
            System.gc();
            new GenUUIDFromMultipleQualifiedGeneratorOrchestrator().orchestrate(100, 100);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testGetNewIDMethodIsThreadsafe() {
        try {
            System.gc();
            new GenUUIDFromSingleQualifiedGeneratorOrchestrator().orchestrate(100, 100);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

