package org.petalslink.abslayer.service.impl.wsdl11;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;

public class BindingImpl implements org.petalslink.abslayer.service.api.Binding {

    private Binding model;

    private Interface interfac;

    // private BindingOperation[] bindingOperations;

    private BindingImpl(Binding model) {
        this.model = model;
    }

    @Override
    public Interface getInterface() {
        if (interfac == null) {
            PortType portType = model.findPortType();
            if (portType == null)
                return null;
            interfac = (org.petalslink.abslayer.service.api.Interface) Factory.getInstance().wrap(portType);
        }
        return interfac;
    }


    @Override
    public BindingOperation getOperationByName(String name) {
        com.ebmwebsourcing.easywsdl11.api.element.BindingOperation bop = model
                .getOperationByName(name);
        if (bop == null)
            return null;
        return (org.petalslink.abslayer.service.api.BindingOperation) Factory.getInstance().wrap(bop);
    }
    
	@Override
	public Description getDescription() {
		Definitions desc = (Definitions) model.getXmlObjectParent();
        if (desc == null)
            return null;
        return (Description) Factory.getInstance().wrap(desc);
	}

	@Override
	public QName getQName() {
		return new QName(this.getDescription().getTargetNamespace(), this.model.getName());
	}

	@Override
	public String toString() {
		return "BindingImpl [model=" + model + "]";
	}

	@Override
	public XmlObject getModel() {
		return this.model;
	}

	@Override
	public BindingOperation[] getOperations() {
		List<BindingOperation> ops = new ArrayList<BindingOperation>();
		com.ebmwebsourcing.easywsdl11.api.element.BindingOperation[] operations = model.getOperations();
		for(com.ebmwebsourcing.easywsdl11.api.element.BindingOperation op: operations) {
			ops.add((org.petalslink.abslayer.service.api.BindingOperation) Factory.getInstance().wrap(op));
		}
		return ops.toArray(new BindingOperation[ops.size()]);
	}

}
