package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Service;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easywsdl11.api.element.Port;

public class EndpointImpl implements org.petalslink.abslayer.service.api.Endpoint {

    private Port model;

    private EndpointImpl(Port model) {
        this.model = model;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((model == null) ? 0 : model.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EndpointImpl other = (EndpointImpl) obj;
        if (model == null) {
            if (other.model != null)
                return false;
        } else if (!model.equals(other.model))
            return false;
        return true;
    }

    @Override
    public String getName() {
        return model.getName();
    }

    @Override
    public String getAddress() {
        XmlObject xo = model.getAnyXmlObjects(new QName(
                "http://schemas.xmlsoap.org/wsdl/soap/", "address"))[0];
        return (String) xo.getXmlObjectAttributes().get(new  QName("location"));
    }

    @Override
    public Service getService() {
        com.ebmwebsourcing.easywsdl11.api.element.Service s = (com.ebmwebsourcing.easywsdl11.api.element.Service) model
                .getXmlObjectParent();
        assert s != null;
        return (org.petalslink.abslayer.service.api.Service) Factory.getInstance().wrap(s);
    }

    @Override
    public org.petalslink.abslayer.service.api.Binding getBinding() {
        return (org.petalslink.abslayer.service.api.Binding) Factory.getInstance().wrap(model.findBinding());
    }
    
	@Override
	public XmlObject getModel() {
		return this.model;
	}

	@Override
	public String toString() {
		return "EndpointImpl [model=" + model + "]";
	}


    
}
