/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.abslayer.service.impl.wsdl11;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyvprop20.api.anonymoustype.PropertyAlias;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Message;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Property;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.abslayer.service.api.Types;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DescriptionImpl
implements Description {
    private DocumentBuilderFactory domBuilder = null;
    private static XmlContext xmlContext = new XmlContextFactory().newContext();
    private ThreadLocal<XmlObjectWriter> xmlwriter = null;
    private final Definitions model;
    private final Map<QName, org.petalslink.abslayer.service.api.Message> messageCache = new HashMap<QName, org.petalslink.abslayer.service.api.Message>();
    private final Map<QName, Interface> interfaceCache = new HashMap<QName, Interface>();
    private final Map<QName, Property> propertyCache = new HashMap<QName, Property>();
    private final Map<QName, List<Endpoint>> endpointsCache = new HashMap<QName, List<Endpoint>>();
    private final Map<QName, List<Element>> elementsCache = new HashMap<QName, List<Element>>();
    private final Map<QName, List<org.petalslink.abslayer.service.api.PropertyAlias>> propertyAliasesCache = new HashMap<QName, List<org.petalslink.abslayer.service.api.PropertyAlias>>();

    private DescriptionImpl(Definitions model) {
        this.model = model;
        this.domBuilder = DocumentBuilderFactory.newInstance();
        this.domBuilder.setNamespaceAware(true);
        this.xmlwriter = new ThreadLocal<XmlObjectWriter>(){

            @Override
            protected XmlObjectWriter initialValue() {
                return xmlContext.createWriter();
            }
        };
    }

    @Override
    public Map<String, String> getNamespaces() {
        return this.model.getXmlObjectInScopeNamespaces();
    }

    @Override
    public URI getDocumentBaseURI() {
        return this.model.getXmlObjectBaseURI();
    }

    @Override
    public String getTargetNamespace() {
        return this.model.getTargetNamespace();
    }

    @Override
    public Types getTypes() {
        return (Types)Factory.getInstance().wrap((XmlObject)this.model.getTypes());
    }

    @Override
    public PartnerLinkType getPartnerLinkType(QName qname) {
        if (!this.model.getTargetNamespace().equals(qname.getNamespaceURI())) {
            return null;
        }
        for (com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType plt : (com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType[])this.model.getAnyXmlObjects(com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType.class)) {
            if (!qname.getLocalPart().equals(plt.getName())) continue;
            return (PartnerLinkType)Factory.getInstance().wrap((XmlObject)plt);
        }
        return null;
    }

    @Override
    public org.petalslink.abslayer.service.api.Message findMessage(QName qname) {
        assert (qname != null);
        if (this.messageCache.containsKey(qname)) {
            return this.messageCache.get(qname);
        }
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            Message result = (Message)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)this.model, String.format("//wsdl11:message[@name='%s'][parent::wsdl11:definitions/@targetNamespace='%s']", qname.getLocalPart(), qname.getNamespaceURI()), Message.class);
            org.petalslink.abslayer.service.api.Message message = result == null ? null : (org.petalslink.abslayer.service.api.Message)Factory.getInstance().wrap((XmlObject)result);
            this.messageCache.put(qname, message);
            return message;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    @Override
    public Interface findInterface(QName qname) {
        assert (qname != null);
        if (this.interfaceCache.containsKey(qname)) {
            return this.interfaceCache.get(qname);
        }
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            PortType result = (PortType)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)this.model, String.format("//wsdl11:portType[@name='%s'][parent::wsdl11:definitions/@targetNamespace='%s']", qname.getLocalPart(), qname.getNamespaceURI()), PortType.class);
            Interface interfac = result == null ? null : (Interface)Factory.getInstance().wrap((XmlObject)result);
            this.interfaceCache.put(qname, interfac);
            return interfac;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    @Override
    public List<Service> findServicesImplementingInterface(Interface itf) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Endpoint ep : this.findEndpointsImplementingInterface(itf)) {
            if (services.contains(ep.getService())) continue;
            services.add(ep.getService());
        }
        return services;
    }

    @Override
    public List<Endpoint> findEndpointsImplementingInterface(Interface itf) {
        assert (itf != null);
        QName itfQname = itf.getQName();
        if (this.endpointsCache.containsKey(itfQname)) {
            return this.endpointsCache.get(itfQname);
        }
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        try {
            com.ebmwebsourcing.easywsdl11.api.element.Binding[] bindings;
            String queryStr = String.format("//wsdl11:binding[@type = QName('%s', '%s')]", itf.getQName().getNamespaceURI(), itf.getQName().getLocalPart());
            for (com.ebmwebsourcing.easywsdl11.api.element.Binding binding : bindings = (com.ebmwebsourcing.easywsdl11.api.element.Binding[])xpathEvaluator.selectXmlObjectNodes((XmlObject)this.model, queryStr, com.ebmwebsourcing.easywsdl11.api.element.Binding.class)) {
                queryStr = String.format("//wsdl11:port[@binding = QName('%s', '%s')]", ((Definitions)binding.getXmlObjectBaseRoot()).getTargetNamespace(), binding.getName());
                Port[] ports = (Port[])xpathEvaluator.selectXmlObjectNodes((XmlObject)this.model, queryStr, Port.class);
                if (ports == null) continue;
                for (Port p : ports) {
                    endpoints.add((Endpoint)Factory.getInstance().wrap((XmlObject)p));
                }
            }
            this.endpointsCache.put(itfQname, endpoints);
            return endpoints;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    @Override
    public Endpoint findEndpoint(String endpointName) {
        assert (endpointName != null);
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            Port result = (Port)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)this.model, String.format("//wsdl11:port[@name='%s']", endpointName), Port.class);
            if (result == null) {
                return null;
            }
            return (Endpoint)Factory.getInstance().wrap((XmlObject)result);
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    @Override
    public Service findService(QName qname) {
        assert (qname != null);
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            com.ebmwebsourcing.easywsdl11.api.element.Service result = (com.ebmwebsourcing.easywsdl11.api.element.Service)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)this.model, String.format("//wsdl11:service[@name='%s'][parent::wsdl11:definitions/@targetNamespace='%s']", qname.getLocalPart(), qname.getNamespaceURI()), com.ebmwebsourcing.easywsdl11.api.element.Service.class);
            if (result == null) {
                return null;
            }
            return (Service)Factory.getInstance().wrap((XmlObject)result);
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    @Override
    public Binding findBinding(QName qname) {
        assert (qname != null);
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            com.ebmwebsourcing.easywsdl11.api.element.Binding result = (com.ebmwebsourcing.easywsdl11.api.element.Binding)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)this.model, String.format("//wsdl11:binding[@name='%s'][parent::wsdl11:definitions/@targetNamespace='%s']", qname.getLocalPart(), qname.getNamespaceURI()), com.ebmwebsourcing.easywsdl11.api.element.Binding.class);
            if (result == null) {
                return null;
            }
            return (Binding)Factory.getInstance().wrap((XmlObject)result);
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    @Override
    public XmlObject getModel() {
        return this.model;
    }

    public List<Element> findElementsInAllSchema(QName qname) {
        if (this.elementsCache.containsKey(qname)) {
            return this.elementsCache.get(qname);
        }
        ArrayList<Element> elementsList = new ArrayList<Element>();
        assert (qname != null);
        Element element = SchemaHelper.findElementByQName((XmlObject)this.model, (QName)qname);
        if (element != null) {
            elementsList.add(element);
        }
        this.elementsCache.put(qname, elementsList);
        return elementsList;
    }

    @Override
    public Property findProperty(QName qname) {
        assert (qname != null);
        if (this.propertyCache.containsKey(qname)) {
            return this.propertyCache.get(qname);
        }
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            com.ebmwebsourcing.easyvprop20.api.anonymoustype.Property result = (com.ebmwebsourcing.easyvprop20.api.anonymoustype.Property)xpathEvaluator.selectSingleXmlObjectNode((XmlObject)this.model, String.format("//vprop:property[@name='%s'][parent::wsdl11:definitions/@targetNamespace='%s']", qname.getLocalPart(), qname.getNamespaceURI()), com.ebmwebsourcing.easyvprop20.api.anonymoustype.Property.class);
            Property property = result == null ? null : (Property)Factory.getInstance().wrap((XmlObject)result);
            this.propertyCache.put(qname, property);
            return property;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    @Override
    public Collection<? extends org.petalslink.abslayer.service.api.PropertyAlias> getPropertyAliases4ThisProperty(QName propName) {
        assert (propName != null);
        if (this.propertyAliasesCache.containsKey(propName)) {
            return this.propertyAliasesCache.get(propName);
        }
        ArrayList<org.petalslink.abslayer.service.api.PropertyAlias> propertyAliases = new ArrayList<org.petalslink.abslayer.service.api.PropertyAlias>();
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            PropertyAlias[] result = (PropertyAlias[])xpathEvaluator.selectXmlObjectNodes((XmlObject)this.model, String.format("//vprop:propertyAlias[namespace-uri-from-QName(@propertyName) = '%s'][local-name-from-QName(@propertyName) = '%s']", propName.getNamespaceURI(), propName.getLocalPart()), PropertyAlias.class);
            if (result != null) {
                for (PropertyAlias propertyAlias : result) {
                    propertyAliases.add((org.petalslink.abslayer.service.api.PropertyAlias)Factory.getInstance().wrap((XmlObject)propertyAlias));
                }
            }
            this.propertyAliasesCache.put(propName, propertyAliases);
            return propertyAliases;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    @Override
    public List<Interface> getInterfaces() {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            PortType[] result = (PortType[])xpathEvaluator.selectXmlObjectNodes((XmlObject)this.model, "//wsdl11:portType", PortType.class);
            if (result == null) {
                return interfaces;
            }
            for (PortType binding : result) {
                interfaces.add((Interface)Factory.getInstance().wrap((XmlObject)binding));
            }
            return interfaces;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    public List<Binding> getBindings() {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            com.ebmwebsourcing.easywsdl11.api.element.Binding[] result = (com.ebmwebsourcing.easywsdl11.api.element.Binding[])xpathEvaluator.selectXmlObjectNodes((XmlObject)this.model, "//wsdl11:binding", com.ebmwebsourcing.easywsdl11.api.element.Binding.class);
            if (result == null) {
                return bindings;
            }
            for (com.ebmwebsourcing.easywsdl11.api.element.Binding binding : result) {
                bindings.add((Binding)Factory.getInstance().wrap((XmlObject)binding));
            }
            return bindings;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    public List<Service> getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            com.ebmwebsourcing.easywsdl11.api.element.Service[] result = (com.ebmwebsourcing.easywsdl11.api.element.Service[])xpathEvaluator.selectXmlObjectNodes((XmlObject)this.model, "//wsdl11:service", com.ebmwebsourcing.easywsdl11.api.element.Service.class);
            if (result == null) {
                return services;
            }
            for (com.ebmwebsourcing.easywsdl11.api.element.Service service : result) {
                services.add((Service)Factory.getInstance().wrap((XmlObject)service));
            }
            return services;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    public List<org.petalslink.abslayer.service.api.Import> getImports() {
        ArrayList<org.petalslink.abslayer.service.api.Import> imports = new ArrayList<org.petalslink.abslayer.service.api.Import>();
        XmlObjectXPathEvaluator xpathEvaluator = this.model.getXmlContext().createXPathEvaluator();
        try {
            Import[] result = (Import[])xpathEvaluator.selectXmlObjectNodes((XmlObject)this.model, "//wsdl11:import", Import.class);
            if (result == null) {
                return imports;
            }
            for (Import impt : result) {
                imports.add((org.petalslink.abslayer.service.api.Import)Factory.getInstance().wrap((XmlObject)impt));
            }
            return imports;
        }
        catch (XPathExpressionException xee) {
            throw new UncheckedException((Throwable)xee);
        }
    }

    @Override
    public Document write() throws XmlObjectWriteException {
        Document doc;
        try {
            doc = this.domBuilder.newDocumentBuilder().newDocument();
            this.xmlwriter.get().writeDocument((XmlObject)this.model, (Node)doc);
        }
        catch (ParserConfigurationException e) {
            throw new UncheckedException(e.getMessage(), (Throwable)e);
        }
        return doc;
    }

    public String toString() {
        return "DescriptionImpl [model=" + this.model + "]";
    }
}

