package com.ebmwebsourcing.easyviper.annotations.detection.processor;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javassist.ClassClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

import com.ebmwebsourcing.easyviper.annotations.detection.Util.Util;
import com.ebmwebsourcing.easyviper.annotations.detection.annotations.changedfields.ChangedFields;
/**
 * Class that manages aspect features according to Viper annotations
 * @author jlesbegueries
 *
 */
public class AspectExecutor {

	/*
	 * Map of <Annotation, List<ClassCanonicalName>>
	 * This is a map populated thanks to the Viper Processor: for each annotation, the list of classes containing
	 * this annotation is retrieved and then Aspect actions can be performed on it.
	 */
	private Map<Class<? extends Annotation>, List<String>> classesToManage = new HashMap<Class<? extends Annotation>, List<String>>();

	
	private Logger log = Logger.getLogger(this.getClass().getCanonicalName());

	public void addPerformingAspect(Class<? extends Annotation> annotation, List<String> listOfClasses) {
		this.classesToManage.put(annotation, listOfClasses);
	}

	public void removePerformingAspect(Class<? extends Annotation> annotation){
		this.classesToManage.remove(annotation);
	}

	public void removeAllPerformingAscpects(){
		this.classesToManage.clear();
	}

	public void performAspect(Class<? extends Annotation> annotation) throws ClassNotFoundException{

		List<String> classes = this.classesToManage.get(annotation);

		if(annotation.getCanonicalName().equalsIgnoreCase(ChangedFields.class.getCanonicalName())){
			performChangedFieldsAspect(classes);
		}else{
			//TODO add actions for other annotations
		}

	}


	/**
	 * Perform aspect code for @ChangedFields annotation
	 * @param classesToManage: List of classes canonical names retrieved
	 * from the code having the @ChangedFields annotation
	 */
	private void performChangedFieldsAspect(List<String> classesToManage){

		Iterator<String> itclasses = classesToManage.iterator();

		/* Javassist classpool in order to load classes 
		 * in which aspectual code has to be added */
		ClassPool pool = ClassPool.getDefault();
		//In order to add current class to classpath (user-defined, e.g. from maven config.
		pool.insertClassPath(new ClassClassPath(this.getClass()));

		try{

			while(itclasses.hasNext()){

				String current = itclasses.next();

				log.info("try to load class "+ current);
				//					Class<?> currentClass = Class.forName(current, initialize, loader)// Class.forName(current);// AspectExecutor.class.getClassLoader().loadClass(current);
				
				CtClass c = pool.get(current);

				//Retrieve all setters methods in order to add ChangedFields aspect code
				List<CtMethod> methods =  Util.findSetters(c);

				// TODO put the following code in some dedicated classes/members and do really something
				// like populating some detector ? store marshalled information ?
				Iterator<CtMethod> itMethods = methods.iterator();
				while(itMethods.hasNext()){

					CtMethod currentMethod = itMethods.next();

					log.info("add adpect to method : "+currentMethod.getName()+ " for class "+current);

					currentMethod.insertAfter("System.out.println(\"NON FUNCTIONNAL CODE.... Add event detector function call ? marshalling process ?\");");

				}
				String pathtowrite = System.getProperty("user.dir")+Util.pathToClasses; 
				
				
				
				c.writeFile(pathtowrite);
			}
		}catch(NotFoundException e){
			e.printStackTrace();
		} 
		catch (Throwable e) {
			e.printStackTrace();
		}
	}
}


