package com.ebmwebsourcing.easyviper.annotations.detection.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

import com.ebmwebsourcing.easyviper.annotations.detection.annotations.changedfields.ChangedFields;


/**
 * Viper Processor in order to manage Viper annotations
 * @author jlesbegueries
 *
 */
//TODO add here other defined Viper annotations 
@SupportedAnnotationTypes(value = { "com.ebmwebsourcing.easyviper.annotations.detection.annotations.changedfields.ChangedFields" })
@SupportedSourceVersion(SourceVersion.RELEASE_6)
public class ViperAnnotationProcessor extends  AbstractProcessor {



	private Logger log = Logger.getLogger(this.getClass().getCanonicalName());

	@Override
	public boolean process(Set<? extends TypeElement> annotations,
			RoundEnvironment roundEnv) {

		this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Entering Viper process ...................................................");


		Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(ChangedFields.class);

		List<String> classesToManage = new ArrayList<String>();

		for(Element element :  elements){


			List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();

			for(AnnotationMirror am : annotationMirrors){
				if(am.getAnnotationType().toString().equals(ChangedFields.class.getCanonicalName())){

					log.info("Process aspect ''"+ ChangedFields.class.getSimpleName()
							+"'' for class " + element.getSimpleName());
					
					classesToManage.add(element.toString());
					
				}

			}
		}

		AspectExecutor executor = new AspectExecutor();
		executor.addPerformingAspect(ChangedFields.class, classesToManage);
		
		try {
			executor.performAspect(ChangedFields.class);
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		
		if(roundEnv.processingOver()){
			this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Exiting Viper process ...................................................");
		}

		//return true in order to tell other processors Viper annotations have been managed and can be skipped.
		return true;

	}
}