/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.annotations.detection.processor;

import com.ebmwebsourcing.easyviper.annotations.detection.annotations.changedfields.ChangedFields;
import com.ebmwebsourcing.easyviper.annotations.detection.processor.AspectExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.ebmwebsourcing.easyviper.annotations.detection.annotations.changedfields.ChangedFields"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ViperAnnotationProcessor
extends AbstractProcessor {
    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Entering Viper process ...................................................");
        Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(ChangedFields.class);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element : set2) {
            List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                if (!annotationMirror.getAnnotationType().toString().equals(ChangedFields.class.getCanonicalName())) continue;
                this.log.info("Process aspect ''" + ChangedFields.class.getSimpleName() + "'' for class " + element.getSimpleName());
                arrayList.add(element.toString());
            }
        }
        AspectExecutor aspectExecutor = new AspectExecutor();
        aspectExecutor.addPerformingAspect(ChangedFields.class, arrayList);
        try {
            aspectExecutor.performAspect(ChangedFields.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        if (roundEnvironment.processingOver()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Exiting Viper process ...................................................");
        }
        return true;
    }
}

